/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.license.client;

import com.prosc.license.client.License;
import org.jetbrains.annotations.Nullable;

public class InvalidLicenseException
extends Exception {
    private final String licenseKey;
    private final String licensedTo;
    private boolean possibleToRetry = false;

    public InvalidLicenseException(String message) {
        this(message, null, null, null);
    }

    public InvalidLicenseException(String message, String licenseKey) {
        this(message, licenseKey, null, null);
    }

    public InvalidLicenseException(String message, @Nullable License invalidLicense) {
        this(message, invalidLicense == null ? null : invalidLicense.getEncryptedKey(), invalidLicense == null ? null : invalidLicense.getRegisteredTo());
    }

    public InvalidLicenseException(String message, @Nullable String licenseKey, @Nullable String licensedTo) {
        this(message, licenseKey, licensedTo, null);
    }

    public InvalidLicenseException(String message, String licenseKey, Throwable cause) {
        this(message, licenseKey, null, cause);
    }

    public InvalidLicenseException(String message, String licenseKey, @Nullable String licensedTo, @Nullable Throwable cause) {
        super(message, cause);
        this.licenseKey = licenseKey;
        this.licensedTo = licensedTo;
    }

    private InvalidLicenseException() {
        this.licenseKey = null;
        this.licensedTo = null;
    }

    public String getLicenseKey() {
        return this.licenseKey;
    }

    public String getLicensedTo() {
        return this.licensedTo;
    }

    public void setPossibleToRetry(boolean possibleToRetry) {
        this.possibleToRetry = possibleToRetry;
    }

    public boolean isPossibleToRetry() {
        return this.possibleToRetry;
    }
}

