/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import com.prosc.shared.StringUtils;
import java.io.IOException;
import java.io.Writer;

public class SimpleXMLWriter
extends Writer {
    Writer writer;
    private boolean isInElement;
    private boolean didWriterDoctype;

    public SimpleXMLWriter(Writer writer) {
        this.writer = writer;
    }

    public SimpleXMLWriter(Writer writer, boolean omitXmlDeclaration) {
        this.writer = writer;
        this.didWriterDoctype = omitXmlDeclaration;
    }

    @Override
    public void write(char[] chars, int i, int i1) throws IOException {
        this.characters(new String(chars, i, i1));
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public void startElement(String elementName) throws IOException {
        if (!this.didWriterDoctype) {
            this.writeDocType();
        }
        this.closeOpenElementTag();
        this.writer.write("<");
        this.writer.write(elementName);
        this.isInElement = true;
    }

    protected void writeDocType() throws IOException {
        this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        this.didWriterDoctype = true;
    }

    private void closeOpenElementTag() throws IOException {
        if (this.isInElement) {
            this.writer.write(62);
            this.isInElement = false;
        }
    }

    public void attributePair(String attrName, String value) throws IOException {
        if (!this.isInElement) {
            throw new IllegalStateException("Cannot write attribute after closing the element tag.");
        }
        this.writer.write(32);
        this.writer.write(attrName);
        this.writer.write("=\"");
        this.writer.write(this.encodedAttributeValue(value));
        this.writer.write(34);
    }

    public void characters(String data) throws IOException {
        this.closeOpenElementTag();
        this.writer.write(this.encodedCharacterData(data));
    }

    public void endElement(String elementName) throws IOException {
        if (this.isInElement) {
            this.writer.write("/>");
        } else {
            this.writer.write("</");
            this.writer.write(elementName);
            this.writer.write(">");
        }
    }

    private String encodedAttributeValue(String data) {
        return StringUtils.escapeXMLString(data);
    }

    private String encodedCharacterData(String data) {
        return StringUtils.escapeXMLString(data);
    }
}

