/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.infrastructure;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Logger;

public class RevisionStampReader {
    private static final Logger log = Logger.getLogger(RevisionStampReader.class.getName());
    private final Properties props = new Properties();

    public RevisionStampReader(File propertyFile) throws IOException {
        try (FileInputStream stream = new FileInputStream(propertyFile);){
            this.readStream(stream);
        }
    }

    public RevisionStampReader(InputStream propertyStream) throws IOException {
        this.readStream(propertyStream);
    }

    private void readStream(InputStream stream) throws IOException {
        this.props.load(stream);
    }

    public Integer getRevisionNumber() {
        String result = this.props.getProperty("build.rev");
        result = result.trim();
        try {
            result = result.substring("$Rev: ".length(), result.lastIndexOf(" $"));
        }
        catch (StringIndexOutOfBoundsException e) {
            log.warning("Could not read the revision number for value '" + result + "'");
            return new Integer(0);
        }
        return Integer.valueOf(result.trim());
    }

    public String getHeadUrl() {
        String result = this.props.getProperty("build.headUrl");
        try {
            return result.substring("$HeadURL:".length(), result.lastIndexOf("$")).trim();
        }
        catch (StringIndexOutOfBoundsException e) {
            log.warning("Could not read the HeadURL for value '" + result + "'");
            return "";
        }
    }

    public String getIpAddress() {
        return this.props.getProperty("build.ip");
    }

    public Date getDeployDate() {
        String result = this.props.getProperty("build.timestamp");
        try {
            result = result.substring("$Date: ".length(), result.indexOf("(")).trim();
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z").parse(result);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        catch (StringIndexOutOfBoundsException e) {
            log.warning("Could not read the date for value '" + result + "'");
            return null;
        }
    }

    public String getAuthor() {
        String result = this.props.getProperty("build.author");
        try {
            return result.substring("$Author:".length(), result.lastIndexOf("$")).trim();
        }
        catch (StringIndexOutOfBoundsException e) {
            log.warning("Could not read the author for value '" + result + "'");
            return "";
        }
    }

    public String getShortInfo() {
        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yy");
        return "Revision " + this.getRevisionNumber() + ", deployed on " + format.format(this.getDeployDate());
    }
}

