/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.format;

import com.prosc.shared.NumberUtils;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;

public class PhoneFormatter
extends Format {
    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj == null) {
            return toAppendTo;
        }
        toAppendTo.append(FormattedPhone.fromString(obj.toString()).externalFormat());
        return toAppendTo;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        int index = pos.getIndex();
        String result = FormattedPhone.fromString(source.substring(index)).internalFormat();
        pos.setIndex(source.length());
        return result;
    }

    public static class FormattedPhone {
        private String areaCode;
        private String exchange;
        private String remainder;
        private String extension;
        private String countryCode;

        public static FormattedPhone fromString(String input) {
            int len;
            if (input == null) {
                return null;
            }
            FormattedPhone result = new FormattedPhone();
            String startValue = input.toString();
            String extString = null;
            int extMark = startValue.indexOf(35);
            if (extMark == -1) {
                extMark = startValue.indexOf(120);
            }
            if (extMark != -1) {
                extString = startValue.substring(extMark + 1);
                if ((extString = NumberUtils.removeNonIntegerChars(extString)).length() > 0) {
                    result.extension = extString;
                }
                startValue = startValue.substring(0, extMark);
            }
            if ((len = (startValue = NumberUtils.removeNonIntegerChars(startValue)).length()) == 7) {
                result.exchange = startValue.substring(0, 3);
                result.remainder = startValue.substring(3, 7);
            } else if (len == 10) {
                result.areaCode = startValue.substring(0, 3);
                result.exchange = startValue.substring(3, 6);
                result.remainder = startValue.substring(6, 10);
            } else if (len > 10) {
                result.countryCode = startValue.substring(0, len - 10);
                startValue = startValue.substring(len - 10);
                result.areaCode = startValue.substring(0, 3);
                result.exchange = startValue.substring(3, 6);
                result.remainder = startValue.substring(6, 10);
            } else {
                result.remainder = startValue;
            }
            return result;
        }

        String externalFormat() {
            return (this.countryCode == null ? "" : this.countryCode + " ") + (this.areaCode == null ? "" : "(" + this.areaCode + ") ") + (this.exchange == null ? "" : this.exchange + "-") + this.remainder + (this.extension == null ? "" : " #" + this.extension);
        }

        String internalFormat() {
            return this.areaCode + this.exchange + this.remainder + (this.extension == null ? "" : "x" + this.extension);
        }

        public String getCountryCode() {
            return this.countryCode;
        }

        public String getAreaCode() {
            return this.areaCode;
        }

        public String getExchange() {
            return this.exchange;
        }

        public String getRemainder() {
            return this.remainder;
        }

        public String getExtension() {
            return this.extension;
        }
    }
}

