/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.format;

import com.prosc.format.SecondsDurationFormatter;
import java.io.PrintStream;
import java.text.Format;
import java.text.NumberFormat;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import org.jetbrains.annotations.NotNull;

public class AsciiProgressBar {
    private final BoundedRangeModel rangeModel;
    private final PrintStream out = System.out;
    private final StringBuilder statusBar;
    @NotNull
    private Format numFormat = NumberFormat.getNumberInstance();
    private int oldPercent;
    private long start;
    private SecondsDurationFormatter tdf = new SecondsDurationFormatter(true);
    private long lastUpdate;

    public AsciiProgressBar(int max) {
        this(new DefaultBoundedRangeModel(0, 0, 0, max));
    }

    public AsciiProgressBar(BoundedRangeModel rangeModel) {
        this.statusBar = new StringBuilder(32);
        for (int i = 0; i < this.statusBar.capacity(); ++i) {
            this.statusBar.append(' ');
        }
        this.statusBar.setCharAt(0, '>');
        this.rangeModel = rangeModel;
        this.rangeModel.addChangeListener(e -> this.updateStatusLine());
    }

    private void updateStatusLine() {
        int newPercent;
        long now = System.currentTimeMillis();
        if (this.start == 0L) {
            this.start = now;
        }
        if ((newPercent = (int)((double)this.rangeModel.getValue() / (double)this.rangeModel.getMaximum() * 100.0)) < 0) {
            newPercent = 100;
        }
        if (newPercent != this.oldPercent || now > this.lastUpdate + 1000L) {
            int startIndex = this.oldPercent * this.statusBar.capacity() / 100;
            int endIndex = Math.min(this.statusBar.capacity(), newPercent * this.statusBar.capacity() / 100);
            for (int index = startIndex; index < endIndex; ++index) {
                this.statusBar.setCharAt(index, '=');
                if (index >= this.statusBar.capacity() - 1) continue;
                this.statusBar.setCharAt(index + 1, '>');
            }
            this.oldPercent = newPercent;
            String additionalInfo = this.additionalInfo();
            String s = String.format("%3d%% [%s] %s ", newPercent, this.statusBar, additionalInfo == null ? "" : additionalInfo);
            this.out.print("\r");
            this.out.print(s);
            if (newPercent == 100) {
                this.out.print("\n");
            }
            this.lastUpdate = now;
        }
    }

    @NotNull
    public final Format getNumFormat() {
        Format format = this.numFormat;
        if (format == null) {
            AsciiProgressBar.$$$reportNull$$$0(0);
        }
        return format;
    }

    public final void setNumFormat(@NotNull Format numFormat) {
        if (numFormat == null) {
            AsciiProgressBar.$$$reportNull$$$0(1);
        }
        this.numFormat = numFormat;
    }

    protected String additionalInfo() {
        String counts = this.numFormat.format(this.getRangeModel().getValue()) + " of " + this.numFormat.format(this.getRangeModel().getMaximum());
        long elapsed = System.currentTimeMillis() - this.start;
        double secondsPerRecord = (double)elapsed / (double)this.rangeModel.getValue();
        double remainingMillis = secondsPerRecord * (double)(this.rangeModel.getMaximum() - this.rangeModel.getValue());
        boolean isDone = this.rangeModel.getValue() >= this.rangeModel.getMaximum();
        String eta = isDone ? "elapsed " + this.tdf.format(elapsed / 1000L) : "eta " + this.tdf.format(remainingMillis / 1000.0);
        return counts + " " + eta;
    }

    public final BoundedRangeModel getRangeModel() {
        return this.rangeModel;
    }

    public final void increment() {
        this.getRangeModel().setValue(this.getRangeModel().getValue() + 1);
    }

    public void complete() {
        this.getRangeModel().setValue(this.rangeModel.getMaximum());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/prosc/format/AsciiProgressBar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "numFormat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNumFormat";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/prosc/format/AsciiProgressBar";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setNumFormat";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

