/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit;

import com.prosc.Platform;
import com.prosc.fm.ClipboardType;
import com.prosc.fmkit.CodeToParent;
import com.prosc.fmkit.FmCalculationException;
import com.prosc.fmkit.FmScriptException;
import com.prosc.fmkit.JackInputStream;
import com.prosc.fmkit.PipeMessageReader;
import com.prosc.fmkit.PipeMessageSource;
import com.prosc.fmkit.Plugin;
import com.prosc.fmkit.PluginBridge2;
import com.prosc.fmkit.PluginFunction;
import com.prosc.fmkit.ScriptCall;
import com.prosc.fmkit.types.FMData;
import com.prosc.fmkit.types.FMDataVect;
import com.prosc.fmkit.types.FMRowVect;
import com.prosc.fmkit.types.FMText;
import com.prosc.fmkit.types.FMType;
import com.prosc.shared.DebugTimer;
import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class PluginContext {
    private static final Logger log = Logger.getLogger(PluginContext.class.getName());
    private final boolean unsafeCalls;
    private final PluginBridge2 theBridge;
    private final Thread filemakerThread;
    private final PluginFunction whichFunction;
    private final long parentThreadId;
    private final long sessionId;
    private final long fileId;
    private final boolean isScriptStep;
    private FMType _functionResult;

    protected PluginContext(PluginBridge2 theBridge, boolean unsafeCalls, Thread filemakerThread, long parentThreadId, long sessionId, long fileId, PluginFunction whichFunction, boolean isScriptStep) {
        this.theBridge = theBridge;
        this.unsafeCalls = unsafeCalls;
        this.filemakerThread = filemakerThread;
        this.parentThreadId = parentThreadId;
        this.whichFunction = whichFunction;
        this.sessionId = sessionId;
        this.fileId = fileId;
        this.isScriptStep = isScriptStep;
    }

    public short getFileMakerAPIVersion() {
        return this.theBridge.getApiVersion();
    }

    public boolean isUnsafeCalls() {
        return this.unsafeCalls;
    }

    Thread getFilemakerThread() {
        return this.filemakerThread;
    }

    long getParentThreadId() {
        return this.parentThreadId;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    long getFileId() {
        return this.fileId;
    }

    boolean isScriptStep() {
        return this.isScriptStep;
    }

    PluginFunction getWhichFunction() {
        return this.whichFunction;
    }

    public <E> E callback(CodeToParent codeToParent, PipeMessageSource messageToParent, PipeMessageReader<E> receiver) {
        return this.theBridge.getPipe().callback(codeToParent, this.parentThreadId, messageToParent, receiver);
    }

    public void triggerScript(ScriptCall script, Plugin whichPlugin) throws FmScriptException {
        try {
            this.triggerScript(script.getFilename(), script.getScriptName(), script.getScriptControl(), script.getParams(), whichPlugin);
        }
        catch (FmScriptException e) {
            script.setExecutionException(e);
            throw e;
        }
    }

    private void triggerScript(String filename, String scriptname, int currentScriptSettings, String parameter, Plugin whichPlugin) throws FmScriptException {
        if (filename == null) {
            throw new IllegalArgumentException("filename must not be null.");
        }
        if (this.getFilemakerThread() == Thread.currentThread()) {
            long paramToken = 0L;
            if (parameter != null && parameter.length() > 0) {
                FMData fmParam = new FMData(this);
                new FMText(this, parameter).writeToData(this, fmParam);
                paramToken = fmParam.getCToken();
            }
            log.fine("Queuing script " + scriptname + " in file " + filename + " from thread " + Thread.currentThread().getName());
            short errorCode = this._triggerScript(filename, scriptname, currentScriptSettings, paramToken);
            log.fine("Script queued");
            if (errorCode != 0) {
                throw new FmScriptException(errorCode, filename, scriptname);
            }
        } else {
            log.fine("Current Thread is " + Thread.currentThread().getName() + "; queueing triggerScript to happen on main thread");
            try {
                this.theBridge.queueFileMakerOperation(context -> {
                    try {
                        log.fine("Triggering script from main thread: " + Thread.currentThread().getName());
                        this.triggerScript(filename, scriptname, currentScriptSettings, parameter, whichPlugin);
                    }
                    catch (FmScriptException e) {
                        log.log(Level.SEVERE, "An error occurred while executing script " + scriptname + " in file " + filename + ": " + e.toString(), e);
                    }
                }, whichPlugin, false);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private short _triggerScript(String filename, String scriptname, int currentScriptSettings, long parameterToken) {
        return this.callback(CodeToParent.triggerScript, out -> {
            out.writeUTF16String(filename);
            out.writeUTF16String(scriptname);
            out.writeInt(currentScriptSettings);
            out.writeLong(parameterToken);
        }, DataInputStream::readShort);
    }

    public FMData evaluateExpression(String expression) throws FmCalculationException {
        if (Thread.currentThread() != this.filemakerThread) {
            log.warning("evaluateExpression called from non-FileMaker thread: " + Thread.currentThread());
        }
        log.fine("evaluateExpression: " + expression);
        if (expression == null) {
            throw new IllegalArgumentException("null value passed to evaluateExpression");
        }
        ExpressionResult expressionResult = this._evaluateExpression(expression);
        short errorCode = expressionResult.errorCode;
        if (errorCode != 0) {
            throw new FmCalculationException(errorCode);
        }
        long dataToken = expressionResult.expressionResult;
        log.finer("dataToken = " + dataToken);
        FMData result = new FMData(dataToken, this.filemakerThread);
        log.fine("result is " + result);
        return result;
    }

    public String getFontName(FMText text, short fontId) {
        throw new AbstractMethodError("This feature has not been implemented yet.");
    }

    private native String _getFontName(long var1, short var3, long var4, long var6, boolean var8);

    public String executeSql(String sql, char columnDelimiter, char rowDelimiter) throws FmCalculationException {
        if (this.theBridge.getApiVersion() >= 54) {
            return this.executeSql13(sql, this.evaluateExpression("Get ( FileName )").getStringData(this), columnDelimiter, rowDelimiter, new String[0]);
        }
        if (this.theBridge.getApiVersion() >= 52) {
            StringBuilder sb = new StringBuilder();
            FMRowVect rowVect = this.executeSql11(sql, this.evaluateExpression("Get ( FileName )").getStringData(this), new String[0]);
            String rDelim = "";
            for (FMDataVect dataVect : rowVect) {
                sb.append(rDelim);
                String cDelim = "";
                for (FMData data : dataVect) {
                    sb.append(cDelim);
                    sb.append(data.getStringData(this, false));
                    cDelim = String.valueOf(columnDelimiter);
                }
                rDelim = String.valueOf(rowDelimiter);
            }
            return sb.toString();
        }
        if (this.theBridge.getApiVersion() < 52) {
            return this.executeSql8(sql, columnDelimiter, rowDelimiter).getStringData(this, false);
        }
        String message = "Could not call executeSql because the optional SQL library is not loaded.";
        throw new RuntimeException(message);
    }

    public FMData executeSql8(@NotNull String sql, char columnDelimiter, char rowDelimiter) throws FmCalculationException {
        if (sql == null) {
            PluginContext.$$$reportNull$$$0(0);
        }
        throw new AbstractMethodError("executeSql8 is no longer supported.");
    }

    private FMRowVect executeSql11(@NotNull String sql, @NotNull String filename, @NotNull String[] params) throws FmCalculationException {
        if (sql == null) {
            PluginContext.$$$reportNull$$$0(1);
        }
        if (filename == null) {
            PluginContext.$$$reportNull$$$0(2);
        }
        if (params == null) {
            PluginContext.$$$reportNull$$$0(3);
        }
        log.config("executeSql with FileMaker 11 API: " + sql);
        ExpressionResult sqlResult = this._executeSql11(sql, filename, params);
        short errorCode = sqlResult.errorCode;
        if (errorCode != 0) {
            throw new FmCalculationException(errorCode);
        }
        long dataToken = sqlResult.expressionResult;
        log.finer("dataToken = " + dataToken);
        FMRowVect result = new FMRowVect(this, dataToken, this.filemakerThread);
        log.fine("result is " + result);
        return result;
    }

    public String executeSql13(@NotNull String sql, @NotNull String filename, char columnDelimiter, char rowDelimiter, @NotNull String[] params) throws FmCalculationException {
        if (sql == null) {
            PluginContext.$$$reportNull$$$0(4);
        }
        if (filename == null) {
            PluginContext.$$$reportNull$$$0(5);
        }
        if (params == null) {
            PluginContext.$$$reportNull$$$0(6);
        }
        log.config("executeSql with FileMaker 13 API: " + sql);
        ExpressionResult sqlResult = this._executeSql13(sql, filename, columnDelimiter, rowDelimiter, params);
        short errorCode = sqlResult.errorCode;
        if (errorCode != 0) {
            throw new FmCalculationException(errorCode);
        }
        long dataToken = sqlResult.expressionResult;
        log.finer("dataToken = " + dataToken);
        String result = this.callback(CodeToParent.getFmDataAsString, out -> out.writeLong(dataToken), JackInputStream::readUTF16String);
        log.fine("result is " + result);
        return result;
    }

    public Object getFieldValue(String filename, String fieldName) throws FmCalculationException {
        String typeInfo;
        if (filename == null) {
            throw new IllegalArgumentException("filename must not be null.");
        }
        log.log(Level.INFO, "Getting field value for filename " + filename + ", fieldname " + fieldName);
        try {
            typeInfo = this.evaluateExpression("FieldType(\"" + filename + "\" ; \"" + fieldName + "\")").getStringData(this);
            log.log(Level.INFO, typeInfo);
        }
        catch (FmCalculationException e) {
            throw new RuntimeException("Unknown field '" + fieldName + "'.  You must pass a \"table::field\" fieldname to the FMPro.getFieldValue function", e);
        }
        FMData value = this.evaluateExpression(fieldName);
        int firstSpaceIndex = typeInfo.indexOf(32);
        int secondSpace = typeInfo.indexOf(32, firstSpaceIndex + 1);
        String typeName = typeInfo.substring(firstSpaceIndex + 1, secondSpace);
        Class targetClass = FMType.classForFMType(typeName);
        try {
            return FMType.converterForClass(targetClass).convertData(value, targetClass, this);
        }
        catch (FMType.UnsupportedTypeConversionException e) {
            log.log(Level.WARNING, "Unable to convert " + value + " to " + targetClass, e);
            return value.getStringData(this);
        }
    }

    private ExpressionResult _evaluateExpression(String expression) {
        return this.callback(CodeToParent.evaluateExpression, out -> out.writeUTF16String(expression), in -> new ExpressionResult(in.readShort(), in.readLong()));
    }

    private ExpressionResult _executeSql11(String sql, String filename, String[] params) {
        return this.callback(CodeToParent.executeSql11, out -> {
            out.writeUTF16String(sql);
            out.writeUTF16String(filename);
            out.writeInt(params.length);
            for (String param : params) {
                out.writeUTF16String(param);
            }
        }, in -> new ExpressionResult(in.readShort(), in.readLong()));
    }

    private ExpressionResult _executeSql13(String sql, String filename, char columnDelimiter, char rowDelimiter, String[] params) {
        return this.callback(CodeToParent.executeSql13, out -> {
            out.writeUTF16String(sql);
            out.writeUTF16String(filename);
            out.writeChar(columnDelimiter);
            out.writeChar(rowDelimiter);
            out.writeInt(params.length);
            for (String param : params) {
                out.writeUTF16String(param);
            }
        }, in -> new ExpressionResult(in.readShort(), in.readLong()));
    }

    public String toString() {
        return "PluginContext{theBridge=" + this.theBridge + '}';
    }

    synchronized void setFunctionResult(FMType functionResult) {
        this._functionResult = functionResult;
    }

    synchronized FMType getFunctionResult() {
        return this._functionResult;
    }

    public String getClipboardDataString(String format, boolean isFileMaker) {
        try {
            byte[] clipBytes = this.getClipboardData(format, isFileMaker);
            if (clipBytes == null) {
                return null;
            }
            String characterEncoding = "utf-8";
            if (format != null && format.contains("utf16")) {
                characterEncoding = "UnicodeLittleUnmarked";
            } else if (format != null && "CF_UNICODETEXT".equals(format)) {
                characterEncoding = "UTF-16LE";
            }
            String clipString = new String(clipBytes, characterEncoding);
            try {
                if (format != null && !ClipboardType.plainText.equals((Object)ClipboardType.forCode(format))) {
                    clipString = clipString.substring(clipString.indexOf(60), clipString.length());
                }
            }
            catch (IllegalArgumentException e) {
                log.log(Level.FINE, format + " is not a FileMaker XML clipboard format", e);
            }
            log.info("Clipboard contents: " + clipString);
            return clipString;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] getClipboardData(String whichFormat, boolean isFileMaker) {
        return this.callback(CodeToParent.getClipboardData, out -> out.writeUTF16String(whichFormat == null ? "" : whichFormat), JackInputStream::readByteArray);
    }

    public String[] getClipboardFormats() {
        return this.callback(CodeToParent.getClipboardFormats, null, in -> {
            String[] result = new String[in.readInt()];
            for (int n = 0; n < result.length; ++n) {
                result[n] = in.readUTF16String();
            }
            return result;
        });
    }

    public String getBestFileMakerClipboardFormat() {
        HashSet<String> availableFormats = new HashSet<String>(Arrays.asList(this.getClipboardFormats()));
        for (ClipboardType eachType : ClipboardType.values()) {
            String fmFormat = this.getFileMakerClipboardFormat(eachType);
            if (!availableFormats.contains(fmFormat)) continue;
            return fmFormat;
        }
        throw new IllegalStateException("The clipboard does not contain data in any recognizable format");
    }

    public String getFileMakerClipboardFormat(ClipboardType type) {
        return type.getFormatCode(this.theBridge.majorVersion, Platform.isMac());
    }

    public void setClipboardData(String format, byte[] data, boolean isFileMaker, boolean clearExisting) {
        byte[] clipboardData;
        if (data != null && Platform.isWin() && format.startsWith("Mac-X") && data[0] == 60) {
            byte b1 = (byte)data.length;
            byte b2 = (byte)(data.length >> 8);
            byte b3 = (byte)(data.length >> 16);
            byte b4 = (byte)(data.length >> 24);
            byte[] header = new byte[]{b1, b2, b3, b4};
            clipboardData = new byte[data.length + header.length];
            System.arraycopy(header, 0, clipboardData, 0, header.length);
            System.arraycopy(data, 0, clipboardData, header.length, data.length);
        } else {
            clipboardData = data;
        }
        this.callback(CodeToParent.setClipboardData, out -> {
            out.writeUTF16String(format);
            out.writeByteArray(clipboardData);
        }, null);
    }

    public Map<String, String> getManifestAttributes(String jarFilePath) {
        return this.callback(CodeToParent.getManifestAttributes, out -> out.writeUTF16String(jarFilePath), in -> {
            DebugTimer timer = new DebugTimer("Started retrieving manifest attributes");
            LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
            int n = in.readInt();
            for (int i = 0; i < n; ++i) {
                attributes.put(in.readUTF16String(), in.readUTF16String());
            }
            timer.markTime("Finished retrieving manifest attributes");
            timer.stop();
            return attributes;
        });
    }

    public long getWindowHandle() {
        long handle = this.callback(CodeToParent.getFmWindowHandle, null, DataInputStream::readLong);
        log.info("Received window handle from c++: " + handle);
        return handle;
    }

    public void disableFmWindows() {
        this.callback(CodeToParent.disableFmWindow, null, null);
    }

    public void enableFmWindows() {
        this.callback(CodeToParent.enableFmWindow, null, null);
    }

    public void disableWindowManagement() {
        this.callback(CodeToParent.disableWindowManagement, null, null);
    }

    public void enableWindowManagement() {
    }

    public Rectangle getWindowCoordinates() {
        return this.callback(CodeToParent.getFmWindowCoordinates, null, in -> {
            int lower_x = (int)in.readLong();
            int lower_y = (int)in.readLong();
            int upper_x = (int)in.readLong();
            int upper_y = (int)in.readLong();
            return new Rectangle(upper_x, upper_y, lower_x - upper_x, lower_y - upper_y);
        });
    }

    public void reactivateJavaWindow() {
        this.callback(CodeToParent.showFauxWindow, null, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sql";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
        }
        objectArray2[1] = "com/prosc/fmkit/PluginContext";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "executeSql8";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "executeSql11";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "executeSql13";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    class ExpressionResult {
        short errorCode;
        long expressionResult;

        ExpressionResult(short errorCode, long expressionResult) {
            this.errorCode = errorCode;
            this.expressionResult = expressionResult;
        }
    }
}

