/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fm;

import com.prosc.database.JDBCHelper;
import com.prosc.shared.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class LetStatementFormat {
    private static final String RECURSE = "?";
    SimpleDateFormat timeFormat = new SimpleDateFormat("H,m,s");
    SimpleDateFormat dateFormat = new SimpleDateFormat("M,d,yyyy");

    public String format(@NotNull Object payload) throws Exception {
        if (payload == null) {
            LetStatementFormat.$$$reportNull$$$0(0);
        }
        if (payload instanceof JDBCHelper.QueryData) {
            return this.format(((JDBCHelper.QueryData)payload).toMaps());
        }
        if (payload instanceof Iterable && !(payload instanceof Map)) {
            Iterable it = (Iterable)payload;
            ArrayList<String> lines = new ArrayList<String>();
            for (Object eachObject : it) {
                String eachLine = this.format(eachObject);
                lines.add(eachLine);
            }
            return StringUtils.join("\n", lines.toArray());
        }
        StringBuilder sb = new StringBuilder("Let([");
        String delim = "";
        this._formatRecursive(payload, sb, delim, "");
        sb.append("];True)");
        return sb.toString();
    }

    private void _formatRecursive(@NotNull Object payload, StringBuilder sb, String delim, String prefix) {
        if (payload == null) {
            LetStatementFormat.$$$reportNull$$$0(1);
        }
        if (payload instanceof Map) {
            Map payloadMap = (Map)payload;
            for (Map.Entry eachEntry : payloadMap.entrySet()) {
                String s = this.fmRepresentationOf(eachEntry.getValue());
                if (s == RECURSE) {
                    this._formatRecursive(eachEntry.getValue(), sb, delim, prefix + eachEntry.getKey() + ".");
                    continue;
                }
                String def = delim + "$" + prefix + eachEntry.getKey() + "=" + s;
                delim = ";";
                sb.append(def);
            }
        } else if (payload instanceof Iterable) {
            assert (!prefix.isEmpty());
            String prefixNoDot = prefix.substring(0, prefix.length() - 1);
            int i = 1;
            for (Object each : (Iterable)payload) {
                String s = this.fmRepresentationOf(each);
                sb.append(delim).append("$").append(prefixNoDot).append("[").append(i).append("]=").append(s == RECURSE ? each.toString() : s);
                delim = ";";
                ++i;
            }
        } else {
            for (Field eachField : payload.getClass().getDeclaredFields()) {
                Object value;
                int mods = eachField.getModifiers();
                if (Modifier.isTransient(mods) || Modifier.isStatic(mods)) continue;
                if (Modifier.isPrivate(mods) || mods == 0) {
                    eachField.setAccessible(true);
                }
                try {
                    value = eachField.get(payload);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (value == null) continue;
                String name = eachField.getName();
                String representation = this.fmRepresentationOf(value);
                if (representation == RECURSE) {
                    this._formatRecursive(value, sb, delim, prefix + name + ".");
                    continue;
                }
                String def = delim + "$" + prefix + name + "=" + representation;
                delim = ";";
                sb.append(def);
            }
        }
    }

    private String fmRepresentationOf(Object value) {
        if (value == null) {
            value = "";
        }
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? "True" : "False";
        }
        if (value instanceof Time) {
            return "Time(" + this.timeFormat.format(value) + ")";
        }
        if (value instanceof Date) {
            return "Date(" + this.dateFormat.format(value) + ")";
        }
        if (value instanceof String) {
            return "\"" + this.quote(value.toString()) + "\"";
        }
        if (value instanceof LocalDate) {
            return "Date(" + ((LocalDate)value).format(DateTimeFormatter.ofPattern("M,d,yyyy")) + ")";
        }
        if (value instanceof LocalTime) {
            return "Time(" + ((LocalTime)value).format(DateTimeFormatter.ofPattern("H,m,s")) + ")";
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime dt = (LocalDateTime)value;
            return "Timestamp(" + this.fmRepresentationOf(dt.toLocalDate()) + "," + this.fmRepresentationOf(dt.toLocalTime()) + ")";
        }
        return RECURSE;
    }

    private String quote(@NotNull String value) {
        if (value == null) {
            LetStatementFormat.$$$reportNull$$$0(2);
        }
        return value.replaceAll("\"", "\\\\\"").replaceAll("\n", "\u00b6");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "payload";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/prosc/fm/LetStatementFormat";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "format";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "_formatRecursive";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "quote";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

