/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fm;

import com.prosc.Platform;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class FMFileUtils {
    private static String bootVolumeName = null;
    private static final Logger log = Logger.getLogger(FMFileUtils.class.getName());
    private static final String VOLUMES = "/Volumes";
    private static final String FILEWIN = "filewin:/";
    private static final String FILEMAC = "filemac:";
    private static final String FILELINUX = "filelinux:";

    public static String convertToFileMaker(String file) {
        return FMFileUtils.convertToFileMaker(new File(file));
    }

    public static String convertToFileMaker(File file) {
        return FMFileUtils.convertToFileMaker(file, false);
    }

    public static String convertToFileMaker(File file, boolean fullyQualified) {
        return FMFileUtils.convertToFileMaker(file, fullyQualified, false);
    }

    public static String convertToFileMaker(File file, boolean fullyQualified, boolean caseInsensitive) {
        int index;
        StringBuilder result = new StringBuilder();
        if (Platform.isMac()) {
            if (fullyQualified) {
                result.append(FILEMAC);
            }
            if (file.getAbsolutePath().startsWith(VOLUMES)) {
                result.append(file.getAbsolutePath().substring(VOLUMES.length()));
            } else {
                result.append("/").append(FMFileUtils.getBootVolumeName());
                result.append(file.getAbsolutePath());
            }
        } else if (Platform.isLin()) {
            if (fullyQualified) {
                result.append(FILELINUX);
            }
            result.append(file.getAbsolutePath());
        } else {
            if (fullyQualified) {
                result.append("filewin:");
            }
            result.append("/").append(file.getAbsolutePath().replace('\\', '/'));
        }
        if (file.isDirectory() && !result.substring(result.length() - 1).equals("/")) {
            result.append("/");
        } else if (caseInsensitive && (index = result.lastIndexOf(file.getName())) != -1) {
            result.replace(index, index + file.getName().length(), file.getName().toLowerCase());
        }
        return result.toString();
    }

    public static File convertFromFileMaker(String filemakerPath) {
        if (filemakerPath.startsWith(FILEMAC)) {
            return new File(VOLUMES, filemakerPath.substring(FILEMAC.length()));
        }
        if (filemakerPath.startsWith(FILEWIN)) {
            return new File(filemakerPath.substring(FILEWIN.length()).replace('/', '\\'));
        }
        if (filemakerPath.startsWith(FILELINUX)) {
            return new File(filemakerPath.substring(FILELINUX.length()));
        }
        throw new IllegalArgumentException("Unknown file protocol: " + filemakerPath);
    }

    public static String getBootVolumeName() {
        try {
            if (bootVolumeName == null) {
                log.info("Getting boot volume name...");
                if (Platform.isMac()) {
                    String eachLine;
                    String[] cmd = new String[]{"/bin/ls", "-l", VOLUMES};
                    Process p = Runtime.getRuntime().exec(cmd);
                    InputStream stream = p.getInputStream();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                    while ((eachLine = reader.readLine()) != null) {
                        if (!eachLine.endsWith(" -> /")) continue;
                        StringTokenizer st = new StringTokenizer(eachLine);
                        for (int n = 0; n < 8; ++n) {
                            st.nextToken();
                        }
                        String temp = st.nextToken("");
                        bootVolumeName = temp.substring(1, temp.length() - 5);
                        break;
                    }
                    if (bootVolumeName == null) {
                        throw new RuntimeException("Couldn't determine boot volume name from ls output");
                    }
                } else {
                    bootVolumeName = "C:";
                }
                log.info("Boot volume name is " + bootVolumeName);
            }
            return bootVolumeName;
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't get boot volume name", e);
        }
    }

    public static boolean isFileMakerDatabase(String name) {
        String nameLc = name.toLowerCase();
        return nameLc.endsWith(".fmp7") || nameLc.endsWith(".fmp12");
    }
}

