/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fm;

import com.prosc.io.ProcessExecutionException;
import com.prosc.shared.StringUtils;

public class FMException
extends Exception {
    private final int errorCode;

    public FMException(int errorCode) {
        super("Error code " + errorCode);
        this.errorCode = errorCode;
    }

    public FMException(int errorCode, String message, Throwable cause) {
        super(message, cause);
        this.errorCode = errorCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int getHttpCode() {
        if (this.errorCode == 201) {
            return 403;
        }
        if (this.errorCode >= 100 && this.errorCode < 200) {
            return 400;
        }
        if (this.errorCode >= 200 && this.errorCode < 300) {
            return 401;
        }
        if (this.errorCode >= 300 && this.errorCode < 306) {
            return 409;
        }
        if (this.errorCode == 306) {
            return 412;
        }
        if (this.errorCode == 401) {
            return 404;
        }
        return 400;
    }

    public static Integer getErrorCode(ProcessExecutionException e) {
        String errorCodeString = StringUtils.textBetween(e.getMessage(), "Error: ", StringUtils.CR).orElse(null);
        if (errorCodeString == null) {
            return null;
        }
        int mark1 = errorCodeString.indexOf(32);
        if (mark1 != -1) {
            errorCodeString = errorCodeString.substring(0, mark1).trim();
        }
        try {
            return Integer.valueOf(errorCodeString);
        }
        catch (NumberFormatException ex) {
            throw new IllegalStateException("Unparseable error code: " + e.getMessage());
        }
    }
}

