/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fm;

import com.prosc.Platform;
import com.prosc.io.ProcessUtils;
import com.prosc.windows.WindowsRegistry;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class FMDirectoryUtils {
    private static final Logger log = Logger.getLogger(FMDirectoryUtils.class.getName());

    @NotNull
    public static File getFmsHome() throws FileNotFoundException {
        File result;
        block16: {
            block15: {
                result = FMDirectoryUtils.checkResult(System.getenv("FMS_HOME"));
                if (result != null) {
                    File file = result;
                    if (file == null) {
                        FMDirectoryUtils.$$$reportNull$$$0(0);
                    }
                    return file;
                }
                if (!Platform.isMac()) break block15;
                result = FMDirectoryUtils.checkResult("/Library/FileMaker Server/");
                if (result == null) {
                    try {
                        String fmserverHomePath = new String(ProcessUtils.doShellCommand(new String[]{"/bin/bash", "-c", "/bin/echo -n ~fmserver"}, null, null), "utf-8");
                        result = FMDirectoryUtils.checkResult(fmserverHomePath);
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Couldn't use echo ~fmserver to get home directory", e);
                    }
                }
                if (result != null) break block16;
                result = FMDirectoryUtils.checkResult("/Library/FileMaker Server 7");
                break block16;
            }
            if (Platform.isLin()) {
                result = new File("/opt/FileMaker/FileMaker Server");
            } else {
                result = FMDirectoryUtils.checkResult(System.getenv("ProgramFiles") + "\\FileMaker\\FileMaker Server");
                if (result == null) {
                    result = FMDirectoryUtils.checkResult(System.getenv("ProgramFiles(x86)") + "\\FileMaker\\FileMaker Server");
                }
                if (result == null) {
                    String[] versions;
                    for (String version : versions = new String[]{"19.9", "19.8", "19.7", "19.6", "19.5", "19.4", "19.3", "19.2", "19.1", "19.0", "18.0", "17.0", "16.0", "15.0", "14.0", "13.0", "12.0", "11.0", "10.0", "9.0", "8.0", "7.0"}) {
                        String registryKey = "HKLM\\SOFTWARE\\FileMaker\\FileMaker Server\\" + version + "\\Services";
                        try {
                            String registryHome = WindowsRegistry.readRegistry(registryKey, "InstallLocation");
                            result = FMDirectoryUtils.checkResult(registryHome);
                            if (result == null) continue;
                        }
                        catch (Exception e) {
                            if (e.getMessage().contains("unable to find the specified registry key") || e.getMessage().contains("not find registry entry")) {
                                log.fine("Could not query registry for location of FileMaker Server using registry key " + registryKey);
                                continue;
                            }
                            log.log(Level.WARNING, "Unexpected error while querying registry", e);
                        }
                        break;
                    }
                }
            }
        }
        if (result == null) {
            throw new FileNotFoundException("Could not locate FileMaker Server directory; it may not be installed on this computer");
        }
        File file = result;
        if (file == null) {
            FMDirectoryUtils.$$$reportNull$$$0(1);
        }
        return file;
    }

    public static String getFMSVersion(File fmsHome) {
        throw new UnsupportedOperationException("not implemented");
    }

    private static File checkResult(String home) {
        File fmsBinary;
        if (home == null) {
            return null;
        }
        File result = new File(home);
        if (result.exists() && (fmsBinary = Platform.isMac() ? new File(result, "Database Server/bin/fmserverd") : new File(result, "Database Server\\fmserver.exe")).exists()) {
            return result;
        }
        return null;
    }

    public static File getHtdocsDir() throws FileNotFoundException {
        File fmsHome = FMDirectoryUtils.getFmsHome();
        File httpServer = new File(fmsHome, "HTTPServer");
        if (Platform.isMac()) {
            return new File(httpServer, "htdocs");
        }
        return new File(httpServer, "Conf");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/prosc/fm/FMDirectoryUtils", "getFmsHome"));
    }
}

