/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fm;

import com.prosc.Platform;
import com.prosc.fm.InvalidClipboardException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public enum ClipboardType {
    layout("dyn.ah62d4rv4gk8zuxnqgk", "dyn.agk8zuxnqm6", "Mac-XML2"),
    script("dyn.ah62d4rv4gk8zuxnxkq", "dyn.agk8zuxnxkq", "Mac-XMSC"),
    scriptStep("dyn.ah62d4rv4gk8zuxnxnq", "dyn.agk8zuxnxnq", "Mac-XMSS"),
    field("dyn.ah62d4rv4gk8zuxngku", "dyn.agk8zuxngku", "Mac-XMFD"),
    table("dyn.ah62d4rv4gk8zuxnykk", "dyn.agk8zuxnykk", "Mac-XMTB"),
    customFunction("dyn.ah62d4rv4gk8zuxngm2", "dyn.agk8zuxngm2", "Mac-XMFN"),
    plainText("com.apple.traditional-mac-plain-text", "com.apple.traditional-mac-plain-text", "CF_TEXT");

    private String mac12Format;
    private String mac11Format;
    private String winFormat;
    private static final Logger log;

    private ClipboardType(String ... formats) {
        this.mac12Format = formats[0];
        this.mac11Format = formats[1];
        this.winFormat = formats[2];
    }

    public static ClipboardType forCode(@NotNull String code) {
        if (code == null) {
            ClipboardType.$$$reportNull$$$0(0);
        }
        for (ClipboardType value : ClipboardType.values()) {
            if (!code.equals(value.mac12Format) && !code.equals(value.mac12Format) && !code.equals(value.winFormat)) continue;
            return value;
        }
        throw new IllegalArgumentException("No clipboard type matches code " + code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClipboardType forXml(@NotNull String xml) throws InvalidClipboardException {
        if (xml == null) {
            ClipboardType.$$$reportNull$$$0(1);
        }
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            DefaultHandler handler = new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if ("Layout".equals(qName)) {
                        throw new StopParseException(layout);
                    }
                    if ("Field".equals(qName)) {
                        throw new StopParseException(field);
                    }
                    if ("Script".equals(qName)) {
                        throw new StopParseException(script);
                    }
                    if ("Step".equals(qName)) {
                        throw new StopParseException(scriptStep);
                    }
                    if ("BaseTable".equals(qName)) {
                        throw new StopParseException(table);
                    }
                    if ("CustomFunction".equals(qName)) {
                        throw new StopParseException(customFunction);
                    }
                }
            };
            try (StringReader reader = new StringReader(xml);){
                parser.parse(new InputSource(reader), handler);
            }
            throw new InvalidClipboardException("The provided XML data contains valid XML, but it is not a recognized FileMaker type");
        }
        catch (StopParseException e) {
            return e.getType();
        }
        catch (SAXException e) {
            log.warning("The clipboard does not contain valid XML");
            return plainText;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public String getFormatCode(int majorVersion, @Nullable Boolean isMac) {
        boolean mac;
        boolean bl = mac = isMac == null ? Platform.isMac() : isMac;
        if (mac) {
            if (majorVersion >= 12) {
                return this.mac12Format;
            }
            return this.mac11Format;
        }
        return this.winFormat;
    }

    public static ClipboardType getClipboardType(String xmlData) throws InvalidClipboardException {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            DefaultHandler handler = new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if ("Layout".equals(qName)) {
                        throw new StopParseException(layout);
                    }
                    if ("Field".equals(qName)) {
                        throw new StopParseException(field);
                    }
                    if ("Script".equals(qName)) {
                        throw new StopParseException(script);
                    }
                    if ("Step".equals(qName)) {
                        throw new StopParseException(scriptStep);
                    }
                    if ("BaseTable".equals(qName)) {
                        throw new StopParseException(table);
                    }
                    if ("CustomFunction".equals(qName)) {
                        throw new StopParseException(customFunction);
                    }
                }
            };
            ByteArrayInputStream bais = new ByteArrayInputStream(xmlData.getBytes("UTF-8"));
            parser.parse((InputStream)bais, handler);
            throw new InvalidClipboardException("The provided XML data contains valid XML, but it is not a recognized FileMaker type");
        }
        catch (StopParseException e) {
            return e.getType();
        }
        catch (SAXException e) {
            log.warning("The clipboard does not contain valid XML");
            return plainText;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        log = Logger.getLogger(ClipboardType.class.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xml";
                break;
            }
        }
        objectArray2[1] = "com/prosc/fm/ClipboardType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "forCode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "forXml";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class StopParseException
    extends SAXException {
        private ClipboardType type;

        private StopParseException(ClipboardType type) {
            super("Stopped Parsing");
            this.type = type;
        }

        public ClipboardType getType() {
            return this.type;
        }
    }
}

