/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.database;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public class FileBlob
implements Blob {
    private static final Logger log = Logger.getLogger(FileBlob.class.getName());
    private final boolean deleteOnFree;
    private final File file;
    private final long length;
    private final List<InputStream> streamsToClose = new LinkedList<InputStream>();
    private RuntimeException freedStackTrace = null;
    private long freedTimestamp = -1L;

    public FileBlob(File file, boolean deleteOnFree) {
        this.file = file;
        this.deleteOnFree = deleteOnFree;
        this.length = file.length();
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        if (this.freedStackTrace != null) {
            throw new IllegalStateException("getBinaryStream failed because free() has already been called on it at " + new Date(this.freedTimestamp) + ". Stack trace of what freed it is included as the cause.", this.freedStackTrace);
        }
        try {
            FileInputStream result = new FileInputStream(this.file);
            this.streamsToClose.add(result);
            return result;
        }
        catch (FileNotFoundException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void free() throws SQLException {
        SQLException closeException = null;
        for (InputStream stream : this.streamsToClose) {
            try {
                stream.close();
            }
            catch (IOException e) {
                closeException = new SQLException(e);
            }
        }
        if (this.deleteOnFree && this.file.exists()) {
            if (this.file.delete()) {
                log.fine("Deleted FileBlob temp file " + this.file.getAbsolutePath());
            } else {
                log.warning("Could not delete temp BLOB data file at " + this.file.getAbsolutePath());
            }
        }
        this.freedStackTrace = new RuntimeException("FileBlob was freed, stack trace only");
        this.freedTimestamp = System.currentTimeMillis();
        if (closeException != null) {
            throw closeException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        try (InputStream stream = this.getBinaryStream(pos, length);){
            byte[] result = new byte[length];
            for (int totalBytesRead = 0; totalBytesRead < length; totalBytesRead += stream.read(result)) {
            }
            byte[] byArray = result;
            return byArray;
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        try {
            long actualBytesSkipped;
            FileInputStream result = new FileInputStream(this.file);
            for (long bytesToSkip = pos - 1L; bytesToSkip > 0L; bytesToSkip -= actualBytesSkipped) {
                actualBytesSkipped = result.skip(bytesToSkip);
                if (actualBytesSkipped != 0L) continue;
                throw new IOException("Could not skip forard the requested amount of bytes (" + (pos - 1L) + ")");
            }
            return result;
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public long position(byte[] pattern, long start) {
        throw new AbstractMethodError("This feature has not been implemented yet.");
    }

    @Override
    public long position(Blob pattern, long start) {
        throw new AbstractMethodError("This feature has not been implemented yet.");
    }

    @Override
    public int setBytes(long pos, byte[] bytes) {
        throw new AbstractMethodError("This feature has not been implemented yet.");
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) {
        throw new AbstractMethodError("This feature has not been implemented yet.");
    }

    @Override
    public OutputStream setBinaryStream(long pos) {
        throw new AbstractMethodError("This feature has not been implemented yet.");
    }

    @Override
    public void truncate(long len) {
        throw new AbstractMethodError("This feature has not been implemented yet.");
    }
}

