/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing.editors;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyEditorSupport;
import java.util.logging.Logger;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;

public class StringEditor
extends PropertyEditorSupport {
    private static final Logger log = Logger.getLogger(StringEditor.class.getName());
    private boolean ignoreUpdates = false;
    protected JTextComponent textField;
    private boolean dirty;

    public StringEditor() {
        this.textField = new JTextField(16);
        this.textField.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent e) {
                if (StringEditor.this.textField.isFocusOwner()) {
                    StringEditor.this.dirty = true;
                } else {
                    StringEditor.this.processChanges();
                }
            }
        });
        this.textField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!e.isTemporary()) {
                    // empty if block
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (StringEditor.this.dirty) {
                    StringEditor.this.processChanges();
                }
            }
        });
        this.textField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                if (StringEditor.this.dirty) {
                    StringEditor.this.processChanges();
                }
                return true;
            }
        });
    }

    public StringEditor(JTextComponent textComponent) {
        this.textField = textComponent;
        this.textField.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent e) {
                StringEditor.this.processChanges();
            }
        });
    }

    private void processChanges() {
        this.ignoreUpdates = true;
        try {
            this.setValue(this.textField.getText());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.ignoreUpdates = false;
            this.dirty = false;
        }
    }

    @Override
    public void setValue(Object value) {
        super.setValue(value);
        if (!this.ignoreUpdates) {
            this.textField.setText(value == null ? null : this.getAsText());
        }
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return this.textField instanceof JTextField ? this.textField : new JScrollPane(this.textField);
    }
}

