/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing.editors;

import com.prosc.swing.editors.StringEditor;
import java.awt.Component;
import java.beans.PropertyEditorSupport;
import java.util.logging.Logger;
import javax.swing.JPasswordField;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;

public class PasswordEditor
extends PropertyEditorSupport {
    private static final Logger log = Logger.getLogger(StringEditor.class.getName());
    protected JPasswordField textField = new JPasswordField(16);
    private boolean ignoreUpdates = false;

    public PasswordEditor() {
        this.textField.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent e) {
                PasswordEditor.this.processChanges();
            }
        });
    }

    private void processChanges() {
        this.ignoreUpdates = true;
        try {
            this.setValue(new String(this.textField.getPassword()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.ignoreUpdates = false;
        }
    }

    @Override
    public void setValue(Object value) {
        super.setValue(value);
        if (!this.ignoreUpdates) {
            this.textField.setText(value == null ? null : this.getAsText());
        }
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return this.textField;
    }
}

