/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing.editors;

import com.prosc.swing.FontPicker;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditorSupport;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class FontEditor
extends PropertyEditorSupport {
    JPanel editorPanel = new JPanel();
    private JLabel fontName;
    private JLabel fontFamily;
    private JLabel fontSize;
    private JLabel fontSummary;
    private JButton clearButton = new JButton("Clear");

    public FontEditor() {
        this.fontName = new JLabel("Font Name: ");
        this.fontFamily = new JLabel("Font Family: ");
        this.fontSize = new JLabel("Font Size: ");
        this.fontSummary = new JLabel("");
        JButton button = new JButton("Select Font");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontPicker fontPicker = new FontPicker();
                fontPicker.setStartingFont((Font)FontEditor.this.getValue());
                Font font = fontPicker.showDialog(null);
                if (font != null) {
                    FontEditor.this.setValue(font);
                }
            }
        });
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontEditor.this.setValue(null);
            }
        });
        this.setValue(null);
        this.editorPanel.setLayout(new FlowLayout(0, 2, 2));
        JPanel buttonPanel = new JPanel(new FlowLayout(0, 0, 0));
        buttonPanel.add(button);
        buttonPanel.add(this.clearButton);
        this.editorPanel.add(this.fontSummary);
        this.editorPanel.add(buttonPanel);
    }

    @Override
    public void setValue(@Nullable Object value) {
        super.setValue(value);
        Font font = (Font)value;
        this.fontName.setText("Font Name: " + (font == null ? "" : font.getFontName()));
        this.fontFamily.setText("Font Family: " + (font == null ? "" : font.getFamily()));
        this.fontSize.setText("Font Size: " + (font == null ? "" : Integer.valueOf(font.getSize())));
        this.fontSummary.setText(font == null ? "" : font.getName() + " " + font.getSize() + "pt");
        this.clearButton.setVisible(value != null);
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return this.editorPanel;
    }
}

