/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing.editors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;

public class DimensionEditor
extends PropertyEditorSupport {
    private static final Logger log = Logger.getLogger(DimensionEditor.class.getName());
    private JPanel editor = new JPanel();
    private boolean ignoreUpdates = false;
    private JSpinner width = new JSpinner();
    private JSpinner height = new JSpinner();

    public DimensionEditor() {
        PropertyChangeListener updater = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DimensionEditor.this.ignoreUpdates = true;
                try {
                    DimensionEditor.this.width.commitEdit();
                    DimensionEditor.this.height.commitEdit();
                    DimensionEditor.this.setValue(new Dimension(((Number)DimensionEditor.this.width.getValue()).intValue(), ((Number)DimensionEditor.this.height.getValue()).intValue()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    DimensionEditor.this.ignoreUpdates = false;
                }
            }
        };
        this.width.addPropertyChangeListener("value", updater);
        this.height.addPropertyChangeListener("value", updater);
        try {
            this.editor.setLayout(new FlowLayout(0, 5, 0));
            Integer maxSizeValue = new Integer(9999);
            Object oldValue = this.width.getValue();
            this.width.setValue(maxSizeValue);
            this.width.setPreferredSize(this.width.getMinimumSize());
            this.height.setPreferredSize(this.width.getMinimumSize());
            this.width.setValue(oldValue);
            this.editor.add(new JLabel("Width: "));
            this.editor.add(this.width);
            this.editor.add(new JLabel("Height: "));
            this.editor.add(this.height);
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, "Could not instantiate DimensionEditor", e);
            throw e;
        }
    }

    @Override
    public void setValue(Object value) {
        super.setValue(value);
        if (!this.ignoreUpdates && value != null) {
            this.width.setValue(new Integer((int)((Dimension)value).getWidth()));
            this.height.setValue(new Integer((int)((Dimension)value).getHeight()));
        }
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return this.editor;
    }
}

