/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class VerticalFlowLayout
implements LayoutManager {
    private int hgap;
    private int vgap;

    public VerticalFlowLayout(int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public int getHgap() {
        return this.hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        int w = 0;
        int h = 0;
        Component[] components = target.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component eachComponent = components[i];
            Dimension dimension = eachComponent.getPreferredSize();
            w = Math.max(w, dimension.width);
            h += this.vgap;
            h += dimension.height;
        }
        return new Dimension(w, h);
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        int w = 0;
        int h = 0;
        Component[] components = target.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component eachComponent = components[i];
            Dimension dimension = eachComponent.getMinimumSize();
            w = Math.max(w, dimension.width);
            h += this.vgap;
            h += dimension.height;
        }
        return new Dimension(w, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension layoutSize(Container target, boolean isMinimum) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension result = new Dimension(0, 0);
            int componentCount = target.getComponentCount();
            boolean firstVisibleComponent = true;
            for (int i = 0; i < componentCount; ++i) {
                Component eachComponent = target.getComponent(i);
                if (!eachComponent.isVisible()) continue;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveComponents(Container target, int x, int y, int rowStart, int rowEnd) {
        Object object = target.getTreeLock();
        synchronized (object) {
            for (int i = rowStart; i < rowEnd; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                m.setLocation(x, y);
                y += m.getHeight() + this.vgap;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int maxheight = target.getHeight() - (insets.top + insets.bottom + this.vgap * 2);
            int componentCount = target.getComponentCount();
            int x = insets.left;
            int y = 0;
            int rowWidth = 0;
            int start = 0;
            for (int i = 0; i < componentCount; ++i) {
                Component eachComponent = target.getComponent(i);
                if (!eachComponent.isVisible()) continue;
                Dimension d = eachComponent.getPreferredSize();
                eachComponent.setSize(d.width, d.height);
                if (y == 0 || y + d.height <= maxheight) {
                    if (y > 0) {
                        y += this.vgap;
                    }
                    y += d.height;
                    rowWidth = Math.max(rowWidth, d.width);
                    continue;
                }
                this.moveComponents(target, x, insets.top + this.vgap, start, i);
                x += this.hgap + rowWidth;
                y = d.height;
                rowWidth = d.width;
                start = i;
            }
            this.moveComponents(target, x, insets.top + this.vgap, start, componentCount);
        }
    }
}

