/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import org.jetbrains.annotations.Nullable;

public class DisclosurePanel
extends JPanel {
    private final JToggleButton triangle = new JToggleButton();
    private final JPanel contentArea;
    private JComponent titleComponent;
    private JComponent expandedView;

    public DisclosurePanel() {
        super(new BorderLayout());
        this.triangle.setBorderPainted(false);
        Icon collapsedIcon = UIManager.getIcon("Tree.collapsedIcon");
        this.triangle.setPreferredSize(new Dimension(collapsedIcon.getIconWidth(), collapsedIcon.getIconHeight()));
        this.triangle.setIcon(collapsedIcon);
        this.triangle.setSelectedIcon(UIManager.getIcon("Tree.expandedIcon"));
        JPanel trianglePanel = new JPanel(new FlowLayout(2, 0, 0));
        trianglePanel.add(this.triangle);
        this.add((Component)trianglePanel, "West");
        this.contentArea = new JPanel(new BorderLayout());
        this.add((Component)this.contentArea, "Center");
        this.triangle.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DisclosurePanel.this.updateState();
            }
        });
    }

    public DisclosurePanel(String titleComponent, JComponent expandedView) {
        this(new JLabel(titleComponent), expandedView);
    }

    public DisclosurePanel(@Nullable JComponent titleComponent, JComponent expandedView) {
        this();
        this.setTitleComponent(titleComponent);
        this.setExpandedView(expandedView);
    }

    public final void setExpandedView(JComponent expandedView) {
        this.expandedView = expandedView;
        this.updateState();
    }

    public JComponent getExpandedView() {
        return this.expandedView;
    }

    public final void setTitleComponent(JComponent titleComponent) {
        if (this.titleComponent != null) {
            this.contentArea.remove(this.titleComponent);
        }
        this.titleComponent = titleComponent;
        this.contentArea.add("North", titleComponent);
        this.revalidate();
    }

    public JComponent getTitleComponent() {
        return this.titleComponent;
    }

    public void setTitle(String titleText) {
        this.setTitleComponent(new JLabel(titleText));
    }

    public String getTitle() {
        if (this.titleComponent instanceof JLabel) {
            return ((JLabel)this.titleComponent).getText();
        }
        return null;
    }

    private void updateState() {
        if (this.triangle.isSelected()) {
            this.contentArea.add((Component)this.expandedView, "Center");
        } else if (this.expandedView != null) {
            this.contentArea.remove(this.expandedView);
        }
        this.contentArea.revalidate();
        this.contentArea.repaint();
    }

    public void expand() {
        this.triangle.setSelected(true);
    }

    public void collapse() {
        this.triangle.setSelected(false);
    }
}

