/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing;

import com.prosc.swing.ColumnTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.Nullable;

public abstract class ColumnTableColumn<E> {
    public static final int DEFAULT_COLUMN_WIDTH = 75;
    private final String label;
    private final Class<E> valueClass;
    private final boolean editable;
    private final int width;
    private final TableCellRenderer tableCellRenderer;
    private final TableCellEditor tableCellEditor;

    public ColumnTableColumn(String label, Class<E> valueClass, boolean editable) {
        this(label, valueClass, editable, 75, null, null);
    }

    protected ColumnTableColumn(String label, Class<E> valueClass, boolean editable, int width, @Nullable TableCellRenderer tableCellRenderer, @Nullable TableCellEditor tableCellEditor) {
        this.label = label;
        this.valueClass = valueClass;
        this.editable = editable;
        this.width = width;
        this.tableCellRenderer = tableCellRenderer;
        this.tableCellEditor = tableCellEditor;
    }

    public abstract E getValue(ColumnTableModel var1, int var2, int var3);

    public void setValue(ColumnTableModel tableModel, E value, int rowIndex, int columnIndex) {
        if (this.isEditable(rowIndex, columnIndex)) {
            throw new UnsupportedOperationException();
        }
    }

    public String getLabel() {
        return this.label;
    }

    public Class<E> getValueClass() {
        return this.valueClass;
    }

    public boolean isEditable(int rowIndex, int columnIndex) {
        return this.editable;
    }

    public TableColumn createTableColumn(int modelIndex) {
        return new TableColumn(modelIndex, this.width, this.tableCellRenderer, this.tableCellEditor);
    }
}

