/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;

public class FileCache {
    private static FileCache sharedCache = null;
    private long maxCacheSize = 524288L;
    private long accessCount = 0L;
    protected HashMap<String, CacheEntry> cache = new HashMap();
    private long currentCacheSize = 0L;

    public FileCache() {
    }

    public FileCache(long maxSize) {
        this.setMaxCacheSize(maxSize);
    }

    public static FileCache sharedCache() {
        if (sharedCache == null) {
            sharedCache = new FileCache();
        }
        return sharedCache;
    }

    public Object getCachedObject(String filepath, String hint) {
        Object result = null;
        CacheEntry theEntry = this.cache.get(filepath + hint);
        if (theEntry != null) {
            if (theEntry.isModified()) {
                this.removeCachedObject(filepath, hint);
            } else {
                theEntry.lastAccess = this.accessCount++;
                result = theEntry.data;
            }
        }
        return result;
    }

    public void removeCachedObject(String filepath, String hint) {
        CacheEntry theEntry = this.cache.get(filepath + hint);
        this.currentCacheSize -= theEntry.size;
        this.cache.remove(filepath + hint);
    }

    public void addObjectToCache(Object data, String filepath, String hint, long size) {
        CacheEntry theEntry;
        if (this.maxCacheSize > 0L && (theEntry = this.cache.get(filepath + hint)) != null) {
            this.currentCacheSize -= theEntry.size;
        }
        theEntry = new CacheEntry(filepath, data, size);
        this.cache.put(filepath + hint, theEntry);
        this.currentCacheSize += size;
        this.trimCache();
    }

    protected void trimCache() {
        System.out.println("Current cache size: " + this.currentCacheSize + "; max size is: " + this.maxCacheSize);
        if (this.maxCacheSize > 0L && this.currentCacheSize > this.maxCacheSize) {
            Collection<CacheEntry> values = this.cache.values();
            Object[] cacheArray = values.toArray(values.toArray(new CacheEntry[values.size()]));
            Arrays.sort(cacheArray);
            int arrayIndex = 0;
            long targetSize = (long)((double)this.maxCacheSize * 0.75);
            while (this.currentCacheSize > targetSize) {
                this.currentCacheSize -= ((CacheEntry)cacheArray[arrayIndex]).size;
                this.cache.remove(cacheArray[arrayIndex]);
                ++arrayIndex;
            }
        }
    }

    public long maxCacheSize() {
        return this.maxCacheSize;
    }

    public void setMaxCacheSize(long input) {
        this.maxCacheSize = input;
        this.trimCache();
    }

    public long currentCacheSize() {
        return this.currentCacheSize;
    }

    public static void main(String[] args) {
        FileCache theCache = FileCache.sharedCache();
        String filePath = "/Users/jesse/Documents/Days off";
        File testFile = new File(filePath);
        String data = (String)theCache.getCachedObject(filePath, null);
        System.out.println("1:Current cache size is: " + theCache.currentCacheSize());
        if (data == null) {
            System.out.println("1:Data not found in cache - this is normal");
            try {
                String line;
                System.out.println("1:Reading data from file");
                BufferedReader reader = new BufferedReader(new FileReader(testFile));
                StringBuffer sb = new StringBuffer();
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
                data = sb.toString();
            }
            catch (FileNotFoundException err) {
                err.printStackTrace();
            }
            catch (IOException err) {
                err.printStackTrace();
            }
        } else {
            System.out.println("1:Data found in cache - this is wrong!!!");
        }
        System.out.println("1:Data contains: " + data);
        System.out.println("1:Storing data in cache.");
        theCache.addObjectToCache(data, filePath, null, data.length());
        System.out.println("1:Current cache size is: " + theCache.currentCacheSize());
        System.out.println("2:Setting data to null");
        data = null;
        System.out.println("2:Data contains: " + data);
        System.out.println("3:Getting data from cache");
        data = (String)theCache.getCachedObject(filePath, null);
        System.out.println("3:Data contains: " + data);
        System.out.println("3:Current cache size is: " + theCache.currentCacheSize());
        System.out.println("4:Updating modification date of file");
        testFile.setLastModified(new Date().getTime());
        System.out.println("4:Getting data from cache");
        data = (String)theCache.getCachedObject(filePath, null);
        System.out.println("4:Current cache size is: " + theCache.currentCacheSize());
        System.out.println("4:Data contains: " + data);
    }

    protected class CacheEntry
    implements Comparable {
        protected Object data;
        protected long size;
        protected long lastModified;
        protected File theFile;
        protected long lastAccess;

        public CacheEntry(String filepath, Object data, long size) {
            this.data = data;
            this.size = size;
            this.theFile = new File(filepath);
            this.lastModified = this.theFile.lastModified();
        }

        public boolean isModified() {
            return this.lastModified != this.theFile.lastModified();
        }

        public int compareTo(Object otherObject) {
            return (int)(this.lastAccess - ((CacheEntry)otherObject).lastAccess);
        }
    }
}

