/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.infrastructure;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import org.jetbrains.annotations.Nullable;

public class MemUtils {
    private static final Logger log = Logger.getLogger(MemUtils.class.getName());
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static volatile HotSpotDiagnosticMXBean hotspotMBean;

    public static void dumpHeap(@Nullable File dumpLocation, boolean live) {
        MemUtils.initHotspotMBean();
        try {
            if (dumpLocation == null) {
                dumpLocation = File.createTempFile("MemUtilsHeapDump", ".hmap");
            }
            hotspotMBean.dumpHeap(dumpLocation.getAbsolutePath(), live);
            log.log(Level.INFO, "Heap dump was generated and written to " + dumpLocation.getAbsolutePath());
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initHotspotMBean() {
        if (hotspotMBean != null) return;
        Class<MemUtils> clazz = MemUtils.class;
        synchronized (MemUtils.class) {
            if (hotspotMBean != null) return;
            hotspotMBean = MemUtils.getHotspotMBean();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static HotSpotDiagnosticMXBean getHotspotMBean() {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            return ManagementFactory.newPlatformMXBeanProxy(server, HOTSPOT_BEAN_NAME, HotSpotDiagnosticMXBean.class);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }
}

