/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.format;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class KilobyteFormat
extends NumberFormat {
    private final NumberFormat format = new DecimalFormat("#,##0.0");

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format((long)number, toAppendTo, pos);
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        int bytes = (int)number;
        if (bytes == 0) {
            toAppendTo.append("0.0 KB");
        } else if (bytes < 52) {
            toAppendTo.append("<0.1 KB");
        } else {
            float kb = (float)Math.round((float)bytes * 10.0f / 1024.0f) / 10.0f;
            toAppendTo.append(this.format.format(kb)).append(" KB");
        }
        return toAppendTo;
    }

    @Override
    public Number parse(String source, ParsePosition parsePosition) {
        throw new AbstractMethodError("parse is not implemented.");
    }
}

