/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit;

import com.prosc.license.client.InvalidLicenseException;
import com.prosc.license.client.Registration;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class LicenseKeyEntryPanel
extends JPanel {
    private Registration registration;
    private static final Logger log = Logger.getLogger(LicenseKeyEntryPanel.class.getName());
    private JTextArea licenseText;
    private JLabel licenseKeyLabel;
    private JTextField licenseKeyField;
    private JTextField registeredToField;
    private JLabel registeredToLabel;

    public LicenseKeyEntryPanel() {
        this.initComponents();
        this.customizeComponents();
    }

    public void checkLicense() throws InvalidLicenseException {
        try {
            String registeredTo = this.registeredToField.getText();
            String licenseKey = this.licenseKeyField.getText();
            log.fine("Registering " + licenseKey + " / registeredTo: " + registeredTo);
            this.registration.setCompanyName(registeredTo);
            this.registration.setLicenseKey(licenseKey);
            this.registration.checkLicense();
            if (this.registration.getLicense().getVariant() == 3 || this.registration.getLicense().getVariant() == 4) {
                throw new InvalidLicenseException("You cannot use a developer license in the preference dialog; you must the registration functions.", this.registration.getLicense());
            }
            this.licenseText.setText(this.registration.getLicenseInfo());
        }
        catch (InvalidLicenseException e) {
            this.licenseText.setText(e.getLocalizedMessage());
            e.setPossibleToRetry(true);
            throw e;
        }
    }

    public void setRegistration(Registration registration, boolean displayLicenseKey) {
        this.registration = registration;
        this.licenseText.setText(registration.getLicenseInfo());
        this.registeredToField.setText(registration.getCompanyName());
        if (displayLicenseKey) {
            this.licenseKeyField.setText(registration.getLicenseKey());
        }
    }

    private void customizeComponents() {
    }

    private void initComponents() {
        this.licenseText = new JTextArea();
        this.licenseKeyLabel = new JLabel();
        this.licenseKeyField = new JTextField();
        this.registeredToField = new JTextField();
        this.registeredToLabel = new JLabel();
        this.setLayout(null);
        this.licenseText.setText("<Plugin name>\nRegistered to: <Company name>\nLicense type: <Put license type here>");
        this.licenseText.setLineWrap(true);
        this.licenseText.setWrapStyleWord(true);
        this.licenseText.setOpaque(false);
        this.licenseText.setEditable(false);
        this.add(this.licenseText);
        this.licenseText.setBounds(50, 10, 300, 65);
        this.licenseKeyLabel.setText("License key:");
        this.add(this.licenseKeyLabel);
        this.licenseKeyLabel.setBounds(new Rectangle(new Point(30, 80), this.licenseKeyLabel.getPreferredSize()));
        this.add(this.licenseKeyField);
        this.licenseKeyField.setBounds(120, 80, 250, this.licenseKeyField.getPreferredSize().height);
        this.add(this.registeredToField);
        this.registeredToField.setBounds(120, 110, 250, 22);
        this.registeredToLabel.setText("Registered to:");
        this.add(this.registeredToLabel);
        this.registeredToLabel.setBounds(new Rectangle(new Point(20, 110), this.registeredToLabel.getPreferredSize()));
        Dimension preferredSize = new Dimension();
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Rectangle bounds = this.getComponent(i).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        Insets insets = this.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.setMinimumSize(preferredSize);
        this.setPreferredSize(preferredSize);
    }
}

