/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.database;

import com.prosc.shared.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public interface Qualifier {
    public static Qualifier or(Qualifier ... children) {
        return new LogicalGroup(LogicalOperator.OR, children);
    }

    public static Qualifier and(Qualifier ... children) {
        return new LogicalGroup(LogicalOperator.AND, children);
    }

    public static <T> Comparison<T> eq(String key, T value) {
        return new Comparison<T>(key, ComparisonOperator.eq, value);
    }

    public static <T> Comparison<T> contains(String key, T value) {
        return new Comparison<T>(key, ComparisonOperator.contains, value);
    }

    public static <T> Comparison<T> gt(String key, T value) {
        return new Comparison<T>(key, ComparisonOperator.gt, value);
    }

    public static <T> Comparison<T> gte(String key, T value) {
        return new Comparison<T>(key, ComparisonOperator.gte, value);
    }

    public static <T> Comparison<T> lt(String key, T value) {
        return new Comparison<T>(key, ComparisonOperator.lt, value);
    }

    public static <T> Comparison<T> lte(String key, T value) {
        return new Comparison<T>(key, ComparisonOperator.lte, value);
    }

    public static class Comparison<T>
    implements Qualifier {
        final ComparisonOperator op;
        final String key;
        final T value;

        Comparison(String key, ComparisonOperator op, T value) {
            this.op = op;
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return this.key + this.op.toSqlOperator() + (this.value == null || this.value instanceof Number ? this.value : "\"" + StringUtils.addSlashes(this.value.toString()) + "\"");
        }
    }

    public static class LogicalGroup
    implements Qualifier {
        final LogicalOperator op;
        Collection<Qualifier> contents;

        LogicalGroup(LogicalOperator op, Qualifier ... contents) {
            this.op = op;
            this.contents = Arrays.asList(contents);
        }

        public String toString() {
            String prefix = this.contents.size() > 1 ? "(" : "";
            String suffix = this.contents.size() > 1 ? ")" : "";
            return this.contents.stream().map(Object::toString).collect(Collectors.joining(" " + this.op.name().toLowerCase() + " ", prefix, suffix));
        }
    }

    public static enum ComparisonOperator {
        eq,
        contains,
        gt,
        gte,
        lt,
        lte;


        @NotNull
        public String toSqlOperator() {
            switch (this) {
                case eq: {
                    return "=";
                }
                case contains: {
                    return "like";
                }
                case gt: {
                    return ">";
                }
                case gte: {
                    return ">=";
                }
                case lt: {
                    return "<";
                }
                case lte: {
                    return "<=";
                }
            }
            throw new IllegalStateException(this.toString());
        }
    }

    public static enum LogicalOperator {
        AND,
        OR;

    }
}

