/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.shared;

import com.prosc.core.WrapperException;
import com.prosc.shared.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;
import org.jetbrains.annotations.Nullable;

public final class ExceptionUtils {
    private static final Logger log = Logger.getLogger(ExceptionUtils.class.getName());
    public static final Thread.UncaughtExceptionHandler defaultExceptionHandler = new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread thread, final Throwable t) {
            if (!(t instanceof ThreadDeath)) {
                final String msg = "Uncaught exception: " + t.toString();
                log.log(Level.SEVERE, msg, t);
                if (!GraphicsEnvironment.isHeadless() && JOptionPane.getRootFrame() != null) {
                    if (EventQueue.isDispatchThread()) {
                        ExceptionUtils.reportException(JOptionPane.getRootFrame(), msg, null, t);
                    } else {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ExceptionUtils.reportException(JOptionPane.getRootFrame(), msg, null, t);
                            }
                        });
                    }
                }
            }
        }
    };

    private ExceptionUtils() {
    }

    public static Throwable getRootCause(Throwable source) {
        while (source.getCause() != null) {
            source = source.getCause();
        }
        return source;
    }

    public static void reportException(Component c, String message, Throwable e1) {
        ExceptionUtils.reportException(c, message, null, e1);
    }

    public static void reportException(final Component c, String message, final @Nullable String title, Throwable e1) {
        if (message == null) {
            message = e1 instanceof RuntimeException || e1 instanceof Error ? e1.toString() : e1.getLocalizedMessage();
        }
        final String messageFinal = message != null ? message : e1.toString();
        Runnable doRun = new Runnable(){

            @Override
            public void run() {
                JComponent panel = ExceptionUtils.createFixedWidthHtmlMessage(messageFinal, 700);
                JOptionPane.showMessageDialog(c, panel, title, 0);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            doRun.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(doRun);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static JComponent createFixedWidthHtmlMessage(String message, int maxWidth) {
        String messageLc = message.toLowerCase();
        if (messageLc.startsWith("<html")) {
            int nestedEndHtml;
            int nestedMarker;
            if (!messageLc.endsWith("</html>")) {
                message = message + "</html>";
                messageLc = messageLc + "</html>";
            }
            if ((nestedMarker = messageLc.indexOf("<html", 6)) != -1 && (nestedEndHtml = messageLc.lastIndexOf("</html", messageLc.length() - 8)) >= 0) {
                int nestedEnd = nestedEndHtml + 7;
                String stringToEscape = message.substring(nestedMarker, nestedEnd);
                String escapedHtml = StringUtils.escapeXMLString(stringToEscape);
                message = message.substring(0, nestedMarker) + escapedHtml + message.substring(nestedEnd);
                message = message.replace("\n", "<br>");
            }
        } else {
            message = "<html>" + message.replace("<", "&lt;").replace(">", "&gt;").replace("\n", "<br>").replace("/", "&#47;") + "</html>";
        }
        JLabel label = new JLabel(message);
        ExceptionUtils.setPreferredSize(label, maxWidth);
        return label;
    }

    public static void setPreferredSize(JLabel label, int maxWidth) {
        ExceptionUtils.setPreferredSize(label, label.getText(), maxWidth);
    }

    public static void setPreferredSize(JComponent component, String text, int maxWidth) {
        if (component.getPreferredSize().width >= maxWidth) {
            View view = BasicHTML.createHTMLView(component, text);
            view.setSize(maxWidth, view.getPreferredSpan(1));
            float preferredSpan = view.getPreferredSpan(1);
            Insets insets = component.getInsets();
            int horizontalInset = insets.left + insets.right;
            int verticalInset = insets.top + insets.bottom;
            component.setPreferredSize(new Dimension(maxWidth + horizontalInset, (int)preferredSpan + verticalInset));
        }
    }

    public static void reportAndLogException(Level level, @Nullable Component c, String msg, @Nullable String title, Throwable t) {
        log.log(level, msg, t);
        ExceptionUtils.reportException(c, msg, title, t);
    }

    public static void reportAndLogException(Level level, @Nullable Component c, String msg, Throwable t) {
        ExceptionUtils.reportAndLogException(level, c, msg, null, t);
    }

    public static RuntimeException rethrowUnchecked(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new RuntimeException(t);
    }

    public static Stream<Throwable> streamChain(Throwable e) {
        Stream.Builder<Throwable> builder = Stream.builder();
        for (Throwable t = e; t != null; t = t.getCause()) {
            builder.add(t);
        }
        return builder.build();
    }

    @Nullable
    public static <E extends Throwable> E findInChain(Throwable error, Class<E> exceptionClassToFind) {
        return (E)((Throwable)ExceptionUtils.streamChain(error).filter(throwable -> exceptionClassToFind.isAssignableFrom(throwable.getClass())).findFirst().orElse(null));
    }

    public static Exception unwrapException(Throwable e) throws Exception {
        if (e instanceof InvocationTargetException) {
            return ExceptionUtils.unwrapException(e.getCause());
        }
        if (e instanceof WrapperException) {
            return ExceptionUtils.unwrapException(e.getCause());
        }
        if (e instanceof Exception) {
            return (Exception)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        throw new IllegalArgumentException("Cannot unwrap " + e, e);
    }

    public static IOException createIOException(Throwable e) {
        IOException result = new IOException(e.getMessage());
        result.initCause(e);
        return result;
    }

    public static <S extends Throwable> S getSpecificCause(Throwable t, Class<S> throwableType) {
        Throwable result;
        for (result = t; result != null && !throwableType.isAssignableFrom(result.getClass()); result = result.getCause()) {
        }
        return (S)result;
    }
}

