/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.shared;

import com.prosc.shared.StringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public class DebugTimer
implements Closeable {
    private static final Logger log = Logger.getLogger(DebugTimer.class.getName());
    private static final String CR = System.getProperty("line.separator");
    private final List<TimeMark> timeMarks = new ArrayList<TimeMark>(1);
    private ThreadLocal<TimeMark> mark = new ThreadLocal<TimeMark>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected TimeMark initialValue() {
            TimeMark result = new TimeMark();
            result.startTime = System.currentTimeMillis();
            result.threadName = Thread.currentThread().getName();
            DebugTimer debugTimer = DebugTimer.this;
            synchronized (debugTimer) {
                DebugTimer.this.timeMarks.add(result);
            }
            return result;
        }
    };
    protected final boolean enabled;
    private boolean stopped = false;

    @Override
    public void close() {
        this.stop();
    }

    public DebugTimer(String debugMessage) {
        this(debugMessage, true);
    }

    public DebugTimer(String debugMessage, boolean enabled) {
        this.enabled = enabled;
        this.markTime("Starting timer: " + debugMessage);
    }

    public void markTime(@Nullable String markMessage) {
        if (!this.enabled) {
            return;
        }
        if (this.stopped) {
            throw new IllegalStateException("markTime was called after DebugTimer was stopped. Message: " + markMessage);
        }
        long timestamp = System.currentTimeMillis();
        this.mark.get().markTime(markMessage, timestamp);
    }

    public void stop() {
        this.stop(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(int threshold) {
        if (this.mark == null) {
            log.log(Level.WARNING, "Stop was called more than once", new RuntimeException("Stop was called more than once"));
            return;
        }
        if (this.enabled) {
            long timestamp = System.currentTimeMillis();
            DebugTimer debugTimer = this;
            synchronized (debugTimer) {
                int totalTime;
                boolean shouldLog = true;
                if (threshold >= 0 && threshold >= (totalTime = (int)(timestamp - this.timeMarks.get(0).startTime))) {
                    shouldLog = false;
                }
                if (shouldLog) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("  DebugTimer stopped on thread " + Thread.currentThread().getName() + CR);
                    for (TimeMark timeMark : this.timeMarks) {
                        timeMark.markTime(null, timestamp);
                        sb.append("    Thread " + timeMark.threadName + ":" + StringUtils.CR + timeMark.progressMessage.toString() + CR);
                    }
                    log.info(sb.toString());
                }
            }
        }
        this.mark.remove();
        this.mark = null;
        DebugTimer debugTimer = this;
        synchronized (debugTimer) {
            this.stopped = true;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (TimeMark timeMark : this.timeMarks) {
            sb.append("    Thread " + timeMark.threadName + ":" + StringUtils.CR + timeMark.progressMessage.toString() + CR);
        }
        return sb.toString();
    }

    public static void main(String[] args) throws IOException {
        int counter;
        DebugTimer testTimer = new DebugTimer("Counting to 5,000,000");
        for (counter = 0; counter < 5000000; ++counter) {
        }
        testTimer.markTime("Counting to 100,000");
        for (counter = 0; counter < 100000; ++counter) {
        }
        testTimer.markTime("Counting  to 20,000,000");
        for (counter = 0; counter < 20000000; ++counter) {
        }
        testTimer.stop();
    }

    static class TimeMark {
        private long startTime;
        private long currentTime;
        private long lastMark;
        private final StringBuilder progressMessage = new StringBuilder();
        private String lastMessage = null;
        private String threadName;

        TimeMark() {
        }

        void markTime(@Nullable String markMessage, long timestamp) {
            this.currentTime = timestamp;
            if (this.lastMessage != null) {
                long markTime = this.currentTime - this.lastMark;
                long totalTime = this.currentTime - this.startTime;
                this.progressMessage.append("        " + markTime + "ms / " + totalTime + "ms: " + this.lastMessage + CR);
            }
            this.lastMessage = markMessage;
            this.lastMark = this.currentTime;
        }

        public String toString() {
            return "TimeMark{startTime=" + this.startTime + ", currentTime=" + this.currentTime + ", lastMark=" + this.lastMark + ", progressMessage=" + this.progressMessage + ", lastMessage='" + this.lastMessage + '\'' + ", threadName='" + this.threadName + '\'' + '}';
        }
    }
}

