/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.license.client;

import com.prosc.license.client.DefaultLicenseDecryptor;
import com.prosc.license.client.InvalidLicenseException;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;

public class License
implements Serializable,
Comparable<License> {
    private final int orderID;
    private final short productCode;
    private final short version;
    private final long maxReleaseDate;
    private final long expirationDate;
    private final long orderDate;
    private final byte variant;
    private final String variantName;
    private final String encryptedKey;
    private final String registeredTo;
    public static final byte DEMO_VARIANT = 0;
    public static final byte STANDARD_VARIANT = 1;
    public static final byte ENTERPRISE_VARIANT = 2;
    public static final byte DEVELOPER_VARIANT = 3;
    public static final byte DEVELOPER_ENTERPRISE_VARIANT = 4;
    public static final byte FBA_ENTERPRISE_VARIANT = 5;
    public static final byte PROFESSIONAL_EDITION_VARIANT = 6;
    public static final byte FREE_VARIANT = 7;
    public static final byte SINGLE_USER_VARIANT = 8;
    public static final byte ADD_ON_VARIANT = 9;
    public static final byte PORTFOLIO_ACTIVATION_VARIANT = 10;
    public static final byte BLACKLISTED_VARIANT = 127;
    public static final int PORTFOLIO_PRODUCT_CODE = 35;
    public static final char ALGORITHM_VERSION_B = 'B';
    public static final char ALGORITHM_VERSION_C = 'C';
    public static final char ALGORITHM_VERSION_D = 'D';

    public License(int orderID, short productCode, short version, byte variant, long orderDate, long expirationDate, long maxReleaseDate, String licenseKey, String companyName) {
        this.orderID = orderID;
        this.productCode = productCode;
        this.version = version;
        this.variant = variant;
        this.variantName = License.variantNameForByte(variant);
        this.orderDate = orderDate;
        this.expirationDate = expirationDate;
        this.maxReleaseDate = maxReleaseDate;
        this.encryptedKey = licenseKey;
        this.registeredTo = companyName;
    }

    public License(String encryptedKey, String registeredTo) throws IllegalArgumentException, InvalidLicenseException {
        DefaultLicenseDecryptor decryptor;
        this.encryptedKey = encryptedKey;
        if (registeredTo != null) {
            registeredTo = registeredTo.trim();
        }
        if (!(decryptor = new DefaultLicenseDecryptor(encryptedKey)).isRegisteredTo(registeredTo)) {
            throw new InvalidLicenseException("The license key is valid, but the registered to name was entered incorrectly.", encryptedKey, registeredTo);
        }
        this.registeredTo = registeredTo;
        this.orderID = decryptor.getOrderId().intValue();
        this.productCode = decryptor.getProductId().shortValue();
        this.version = decryptor.getVersion().shortValue();
        this.variant = decryptor.getVariant();
        this.variantName = License.variantNameForByte(this.variant);
        this.orderDate = decryptor.getOrderDate().getTime();
        this.expirationDate = decryptor.getExpirationDate() == null ? Long.MAX_VALUE : decryptor.getExpirationDate().getTime();
        this.maxReleaseDate = decryptor.getMaxReleaseDate();
    }

    public int getOrderID() {
        return this.orderID;
    }

    public short getProductCode() {
        return this.productCode;
    }

    public short getVersion() {
        return this.version;
    }

    public byte getVariant() {
        return this.variant;
    }

    public long getExpirationDate() {
        return this.expirationDate;
    }

    public long getMaxReleaseDate() {
        return this.maxReleaseDate;
    }

    public String getEncryptedKey() {
        return this.encryptedKey;
    }

    public String getRegisteredTo() {
        return this.registeredTo;
    }

    public String getVariantName() {
        return License.variantNameForByte(this.variant);
    }

    public static String variantNameForByte(byte variantByte) {
        switch (variantByte) {
            case 0: {
                return "Demo version(0)";
            }
            case 1: {
                return "Workgroup License(1)";
            }
            case 8: {
                return "Single User License(8)";
            }
            case 2: {
                return "Enterprise License(2)";
            }
            case 3: {
                return "Developer License (Workgroup)(3)";
            }
            case 4: {
                return "Solution Bundling License(4)";
            }
            case 5: {
                return "FBA Member License(5)";
            }
            case 6: {
                return "Professional Edition(6)";
            }
            case 7: {
                return "Free License(7)";
            }
            case 127: {
                return "Disabled(127)";
            }
        }
        return "Unknown License Type " + variantByte;
    }

    public boolean isPortfolio() {
        return this.getProductCode() == 35;
    }

    @Override
    public int compareTo(License o) {
        if (o == null) {
            return 1;
        }
        return this.getRegistrationPriority() - o.getRegistrationPriority();
    }

    private int getRegistrationPriority() {
        switch (this.variant) {
            case 0: {
                return 0;
            }
            case 7: {
                return 10;
            }
            case 8: {
                return 20;
            }
            case 1: {
                return 30;
            }
            case 3: {
                return 40;
            }
            case 2: {
                return 50;
            }
            case 4: {
                return 60;
            }
            case 5: {
                return 70;
            }
            case 6: {
                return 80;
            }
        }
        return 100;
    }

    public String toString() {
        return "License{orderID=" + this.orderID + ", productCode=" + this.productCode + ", version=" + this.version + ", maxReleaseDate=" + this.maxReleaseDate + ", expirationDate=" + this.expirationDate + ", variant=" + this.variant + ", encryptedKey='" + this.encryptedKey + '\'' + ", registeredTo='" + this.registeredTo + '\'' + '}';
    }

    public String toHtml() {
        DateFormat df = DateFormat.getDateInstance(2);
        return "<table><tr><td>registeredTo</td><td>" + this.registeredTo + "</td></tr><tr><td>expirationDate</td><td>" + df.format(new Date(this.expirationDate)) + "</td></tr><tr><td>maxReleaseDate</td><td>" + df.format(new Date(this.maxReleaseDate)) + "</td></tr><tr><td>orderDate</td><td>" + df.format(new Date(this.orderDate)) + "</td></tr><tr><td>orderId</td><td>" + this.orderID + "</td></tr><tr><td>productCode</td><td>" + this.productCode + "</td></tr><tr><td>variant</td><td>" + this.variant + "</td></tr><tr><td>version</td><td>" + this.version + "</td></tr></table>";
    }

    public long getOrderDate() {
        return this.orderDate;
    }
}

