/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.infrastructure;

import com.prosc.infrastructure.VersionItem;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

public class VersionManager {
    private static final Logger log = Logger.getLogger(VersionManager.class.getName());
    private Class versionedClass;
    private static final String PREV_VERSION = "previousVersion";
    private SortedMap<Float, VersionItem> versionMap;

    public VersionManager(Class versionedClass) {
        if (versionedClass == null) {
            throw new IllegalArgumentException("You cannot pass a null versionedClass to the constructor.");
        }
        this.versionedClass = versionedClass;
        this.versionMap = new TreeMap<Float, VersionItem>(new Comparator<Float>(){

            @Override
            public int compare(Float o, Float o1) {
                return o.compareTo(o1);
            }
        });
    }

    public final void addItem(VersionItem item) {
        if (item.getVersionNumber() == -1.0f) {
            throw new IllegalArgumentException("You cannot use -1 as a version number; it is a reserved value.");
        }
        if (this.getVersionNumber(item.getVersionNumber()) != null) {
            throw new IllegalArgumentException("You may not add the same VersionItem (" + item.getVersionNumber() + ") twice.");
        }
        this.versionMap.put(new Float(item.getVersionNumber()), item);
    }

    public final void addItems(VersionItem[] items) {
        for (int n = 0; n < items.length; ++n) {
            this.addItem(items[n]);
        }
    }

    public final VersionItem getCurrentVersion() {
        return (VersionItem)this.versionMap.get(this.versionMap.lastKey());
    }

    public final VersionItem getFirstVersion() {
        return (VersionItem)this.versionMap.get(this.versionMap.firstKey());
    }

    public final String getCurrentVersionNumberAndDate() {
        DateFormat dateFormat = DateFormat.getDateInstance(2);
        return this.getCurrentVersion().getVersionNumber() + " : " + dateFormat.format((Object)this.getCurrentVersion().getVersionDate());
    }

    public final String getCurrentVersionStringAndDate() {
        DateFormat dateFormat = DateFormat.getDateInstance(2);
        return this.getCurrentVersion().getVersionString() + " : " + dateFormat.format((Object)this.getCurrentVersion().getVersionDate());
    }

    public final void updateToCurrentVersion() throws VersionMissingException {
        VersionItem previousVersion = this.getPreviousVersion();
        if (previousVersion == this.getCurrentVersion()) {
            log.log(Level.INFO, "No update is necessary - already up-to-date.");
        } else {
            Collection<VersionItem> values = this.versionMap.values();
            VersionItem[] versions = values.toArray(new VersionItem[values.size()]);
            Arrays.sort(versions, new Comparator<VersionItem>(){

                @Override
                public int compare(VersionItem o, VersionItem o1) {
                    VersionItem v = o;
                    VersionItem v1 = o1;
                    int out = v.getUpdateExecutionOrder() - v1.getUpdateExecutionOrder();
                    if (out == 0) {
                        out = v.getVersionNumber() > v1.getVersionNumber() ? 1 : -1;
                    }
                    return out;
                }
            });
            log.info("Upgrading to new version...");
            float newVersion = 0.0f;
            for (VersionItem version : versions) {
                VersionItem eachVersion = version;
                if (eachVersion.getVersionNumber() <= previousVersion.getVersionNumber()) continue;
                System.out.print(eachVersion.userPresentableDescription() + "... ");
                eachVersion.doUpdate();
                log.info("update " + eachVersion.toString() + " done");
                this.setPreviousVersionNumber(eachVersion.getVersionNumber());
                newVersion = Math.max(newVersion, eachVersion.getVersionNumber());
            }
            this.setPreviousVersionNumber(newVersion);
            log.info("Finished upgrade.");
        }
    }

    public final VersionItem getPreviousVersion() throws VersionMissingException {
        float prevNumber = this.getPreviousVersionNumber();
        VersionItem result = this.getVersionNumber(prevNumber);
        if (result == null) {
            throw new WrongVersionException(prevNumber, this.getCurrentVersion().getVersionNumber(), this.getVersionHistory());
        }
        return result;
    }

    public final void setPreviousVersion(VersionItem previousItem) {
        this.setPreviousVersionNumber(previousItem.getVersionNumber());
    }

    public final Class getVersionedClass() {
        return this.versionedClass;
    }

    protected float getPreviousVersionNumber() throws VersionMissingException {
        Preferences prefs = Preferences.userNodeForPackage(this.getVersionedClass());
        float previousVersion = prefs.getFloat(PREV_VERSION, -1.0f);
        if (previousVersion == -1.0f) {
            throw new VersionMissingException("Couldn't determine previous version number");
        }
        return previousVersion;
    }

    protected void setPreviousVersionNumber(float input) {
        Preferences prefs = Preferences.userNodeForPackage(this.getVersionedClass());
        prefs.putFloat(PREV_VERSION, input);
    }

    private VersionItem getVersionNumber(float versionNumber) {
        return (VersionItem)this.versionMap.get(new Float(versionNumber));
    }

    public final String getVersionHistory() {
        StringBuffer result = new StringBuffer();
        ArrayList<VersionItem> itemList = new ArrayList<VersionItem>(this.versionMap.values());
        Collections.reverse(itemList);
        Iterator it = itemList.iterator();
        if (it.hasNext()) {
            result.append(((VersionItem)it.next()).userPresentableDescription());
        }
        while (it.hasNext()) {
            result.append("\n" + ((VersionItem)it.next()).userPresentableDescription());
        }
        return result.toString();
    }

    public static final class WrongVersionException
    extends RuntimeException {
        private static final long serialVersionUID = 2733340328353251318L;
        private String versionHistory;

        public WrongVersionException(float versionFound, float thisVersion, String versionHistory) {
            super("Previous version number is " + versionFound + ", which does match any of the VersionItems added to this manager. The current version in the application code is " + thisVersion + ". You may be running an old version of the application.");
            this.versionHistory = versionHistory;
        }

        public String getVersionHistory() {
            return this.versionHistory;
        }

        @Override
        public String toString() {
            return super.toString() + "\n" + this.versionHistory;
        }
    }

    public static final class VersionMissingException
    extends Exception {
        private static final long serialVersionUID = 8698410055717895382L;

        public VersionMissingException(String s) {
            super(s);
        }
    }
}

