/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.format;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;

public class WordWrapFormatter
extends Format {
    private String indentTemplate = "";
    private int indentTemplateCharCount;
    private String breakTemplate = "\n";
    private boolean isHtmlAware = false;
    private int wrapLength = 70;
    private int strictMaxLength = Integer.MAX_VALUE;
    private boolean stripMultipleLineBreaks = true;

    public static WordWrapFormatter getHtmlInstance() {
        WordWrapFormatter result = new WordWrapFormatter();
        result.setBreakTemplate("<br/>");
        result.setIndentTemplate(null);
        result.setHtmlAware(true);
        return result;
    }

    public static WordWrapFormatter getPlainTextInstance() {
        WordWrapFormatter result = new WordWrapFormatter();
        result.setBreakTemplate("\n");
        result.setHtmlAware(false);
        result.setIndentTemplate(null);
        result.setWrapLength(60);
        result.setStrictMaxLength(70);
        return result;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj == null) {
            return toAppendTo;
        }
        String s = (String)obj;
        int len = s.length();
        int charCount = 0;
        int lastAppendedIndex = 0;
        boolean didBreak = false;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (this.isHtmlAware && c == '<') {
                System.out.println("Found opening HTML tag at " + i);
                while (s.charAt(i) != '>' && ++i != len) {
                }
            } else if (c == '\n') {
                toAppendTo.append(s.substring(lastAppendedIndex, i++));
                toAppendTo.append('\n');
                didBreak = true;
            } else if (charCount >= this.wrapLength && Character.isWhitespace(c) || charCount >= this.strictMaxLength) {
                toAppendTo.append(s.substring(lastAppendedIndex, i));
                toAppendTo.append('\n');
                didBreak = true;
            }
            if (didBreak) {
                while (i < len && Character.isWhitespace(s.charAt(i)) && (s.charAt(i) != '\n' || this.stripMultipleLineBreaks)) {
                    ++i;
                }
                toAppendTo.append(this.indentTemplate);
                lastAppendedIndex = --i + 1;
                charCount = this.indentTemplateCharCount;
                didBreak = false;
                continue;
            }
            ++charCount;
        }
        toAppendTo.append(s.substring(lastAppendedIndex));
        return toAppendTo;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return null;
    }

    public String getIndentTemplate() {
        return this.indentTemplate;
    }

    public void setIndentTemplate(String indentTemplate) {
        this.indentTemplate = indentTemplate;
        if (indentTemplate != null) {
            String decodedTemplate = indentTemplate.replaceAll("&nbsp;", " ");
            decodedTemplate = decodedTemplate.replaceAll("\\\\t", "    ");
            this.indentTemplateCharCount = decodedTemplate.length();
        } else {
            this.indentTemplate = "";
            this.indentTemplateCharCount = 0;
        }
    }

    public String getBreakTemplate() {
        return this.breakTemplate;
    }

    public void setBreakTemplate(String breakTemplate) {
        this.breakTemplate = breakTemplate;
    }

    public void setHtmlAware(boolean htmlAware) {
        this.isHtmlAware = htmlAware;
    }

    public void setWrapLength(int wrapLength) {
        this.wrapLength = wrapLength;
    }

    public void setStrictMaxLength(int strictMaxLength) {
        this.strictMaxLength = strictMaxLength;
    }

    public static void main(String[] args) {
        System.out.println("");
        String body = "Instructions and Positions: instructions & positions. This instructions field has line breaks innit.  Long amounts of text.  Text should be wrapped.  instructions & positions. This instructions field has line breaks innit.  Long amounts of text.  Text should be wrapped.  instructions & positions. Supercalifragilisticexpialidocious! Supercalifragilisticexpialidocious! Supercalifragilisticexpialidocious! This instructions field has line breaks innit.  Long amounts of text.  Text should be wrapped.  instructions & positions. This instructions field has line breaks innit.  Long amounts of text.  Text should be wrapped.  instructions & positions. Supercalifragilisticexpialidocious! Supercalifragilisticexpialidocious! Supercalifragilisticexpialidocious! This instructions field has line breaks innit.  Long amounts of text.  Text should be wrapped.  instructions & positions.\nThis instructions field has line breaks innit.  Long amounts of text.  Text should be wrapped.This instructions field has line breaks innit.  Long amounts of text.  Text should be wrapped.  instructions & positions. <a href=\"http://www.360works.com/foo\">This is a link to a long URL</a>.  If HTML aware, the formatter should not include the length of the URL.This instructions field has line breaks innit.  Long amounts of text.  Text should be wrapped.  instructions & positions. Publications: n/a\nRecruiter Fax: 415 929 7318\nAd Dates: 1/2/32\nResponse Information: quo lipsum ipsum bitty bam bam.\nadStyle: \nAttachment.filename: base64.php\nRecruiter Phone: 415 929 7318\n0.0.6.4.6.0.1.1.1.0: bla\nAttachment.mimetype: application/octet-stream\nRecruiter Email: sam@360works.com";
        WordWrapFormatter instance = new WordWrapFormatter();
        instance.isHtmlAware = false;
        instance.setWrapLength(65);
        instance.setStrictMaxLength(75);
        instance.setBreakTemplate("\n");
        instance.setIndentTemplate(null);
        System.out.println("\n==== HTML-AWARE ===\n");
        instance.setHtmlAware(true);
        System.out.println(instance.format(body));
    }

    public boolean isStripMultipleLineBreaks() {
        return this.stripMultipleLineBreaks;
    }

    public void setStripMultipleLineBreaks(boolean stripMultipleLineBreaks) {
        this.stripMultipleLineBreaks = stripMultipleLineBreaks;
    }

    public int getWrapLength() {
        return this.wrapLength;
    }
}

