/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit;

import com.prosc.fmkit.Plugin;
import com.prosc.license.client.Registration;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class BugReporter
extends JDialog {
    private static final Logger log = Logger.getLogger(BugReporter.class.getName());
    private Plugin whichPlugin;
    private Registration registration;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JPanel panel1;
    private JCheckBox includeLogOption;
    private JLabel label1;
    private JPanel panel2;
    private JLabel label2;
    private JTextField emailField;
    private JLabel label3;
    private JTextField phoneField;
    private JLabel label4;
    private JScrollPane scrollPane1;
    private JTextArea problemField;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;

    public BugReporter(Frame parent, Plugin whichPlugin, Registration registration) {
        super(parent, true);
        this.whichPlugin = whichPlugin;
        this.registration = registration;
        this.initComponents();
    }

    public BugReporter(Dialog parent, Plugin whichPlugin, Registration registration) {
        super(parent, true);
        this.whichPlugin = whichPlugin;
        this.registration = registration;
        this.initComponents();
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.panel1 = new JPanel();
        this.includeLogOption = new JCheckBox();
        this.label1 = new JLabel();
        this.panel2 = new JPanel();
        this.label2 = new JLabel();
        this.emailField = new JTextField();
        this.label3 = new JLabel();
        this.phoneField = new JTextField();
        this.label4 = new JLabel();
        this.scrollPane1 = new JScrollPane();
        this.problemField = new JTextArea();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BorderLayout());
        this.panel1.setLayout(new FlowLayout(4));
        this.includeLogOption.setText("Include log file");
        this.includeLogOption.setSelected(true);
        this.panel1.add(this.includeLogOption);
        this.contentPanel.add((Component)this.panel1, "South");
        this.label1.setText("Enter your bug report in the fields below:");
        this.contentPanel.add((Component)this.label1, "North");
        this.panel2.setLayout(new GridBagLayout());
        ((GridBagLayout)this.panel2.getLayout()).columnWidths = new int[]{0, 0, 0};
        ((GridBagLayout)this.panel2.getLayout()).rowHeights = new int[]{0, 0, 0, 0, 0};
        ((GridBagLayout)this.panel2.getLayout()).columnWeights = new double[]{0.0, 1.0, 1.0E-4};
        ((GridBagLayout)this.panel2.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 1.0, 1.0E-4};
        this.label2.setText("Email:");
        this.panel2.add((Component)this.label2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.panel2.add((Component)this.emailField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.label3.setText("Phone number:");
        this.panel2.add((Component)this.label3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.panel2.add((Component)this.phoneField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.label4.setText("Problem description");
        this.panel2.add((Component)this.label4, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.scrollPane1.setMinimumSize(new Dimension(300, 200));
        this.scrollPane1.setPreferredSize(new Dimension(400, 200));
        this.problemField.setWrapStyleWord(true);
        this.problemField.setLineWrap(true);
        this.scrollPane1.setViewportView(this.problemField);
        this.panel2.add((Component)this.scrollPane1, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.contentPanel.add((Component)this.panel2, "Center");
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.okButton.setText("OK");
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText("Cancel");
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BugReporter.this.dispose();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BugReporter.this.submitBug();
                    JOptionPane.showConfirmDialog(BugReporter.this, "Problem report sent!\n\nPlease check your email for a confirmation message.", "Problem Report Sent", -1);
                    BugReporter.this.dispose();
                }
                catch (IllegalArgumentException e1) {
                    JOptionPane.showMessageDialog(BugReporter.this, e1.getLocalizedMessage(), "Could not submit bug report", 0);
                }
                catch (Exception e1) {
                    log.log(Level.SEVERE, "Could not submit bug report", e1);
                    JOptionPane.showMessageDialog(BugReporter.this, e1.getLocalizedMessage(), "Could not submit bug report", 0);
                }
            }
        });
    }

    private void submitBug() throws IOException {
        if (this.emailField.getText() == null || this.emailField.getText().length() == 0) {
            throw new IllegalArgumentException("You must include an email address");
        }
        String emailAddress = this.emailField.getText();
        String problemReport = this.problemField.getText();
        String phoneNumber = this.phoneField.getText();
        int orderId = 0;
        String licenseInfo = null;
        if (this.registration != null) {
            orderId = this.registration.getLicense().getOrderID();
            licenseInfo = this.registration.getLicenseInfo();
        }
        if (this.includeLogOption.isSelected()) {
            this.whichPlugin.reportProblem(emailAddress, problemReport, phoneNumber, orderId, licenseInfo, true);
        } else {
            this.whichPlugin.reportProblem(emailAddress, problemReport, phoneNumber, orderId, licenseInfo, false);
        }
    }
}

