/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fm;

import com.prosc.database.JDBCHelper;
import com.prosc.shared.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class LetStatementFormat {
    public String format(@NotNull Object payload) throws Exception {
        if (payload == null) {
            LetStatementFormat.$$$reportNull$$$0(0);
        }
        if (payload instanceof JDBCHelper.QueryData) {
            return this.format(((JDBCHelper.QueryData)payload).toMaps());
        }
        StringBuilder sb = new StringBuilder("Let([");
        String delim = "";
        SimpleDateFormat timeFormat = new SimpleDateFormat("H,m,s");
        SimpleDateFormat dateFormat = new SimpleDateFormat("M,d,yyyy");
        if (payload instanceof Map) {
            Map payloadMap = (Map)payload;
            for (Map.Entry eachEntry : payloadMap.entrySet()) {
                String def = delim + "$" + eachEntry.getKey() + "=" + this.fmRepresentationOf(eachEntry.getValue(), timeFormat, dateFormat);
                delim = ";";
                sb.append(def);
            }
        } else {
            if (payload instanceof Iterable) {
                Iterable it = (Iterable)payload;
                ArrayList<String> lines = new ArrayList<String>();
                for (Object eachObject : it) {
                    String eachLine = this.format(eachObject);
                    lines.add(eachLine);
                }
                return StringUtils.join("\n", lines.toArray());
            }
            for (Field eachField : payload.getClass().getDeclaredFields()) {
                Object value;
                int mods = eachField.getModifiers();
                if (Modifier.isTransient(mods) || Modifier.isStatic(mods)) continue;
                if (Modifier.isPrivate(mods)) {
                    eachField.setAccessible(true);
                }
                if ((value = eachField.get(payload)) == null) continue;
                String name = eachField.getName();
                String def = delim + "$" + name + "=" + this.fmRepresentationOf(value, timeFormat, dateFormat);
                delim = ";";
                sb.append(def);
            }
        }
        sb.append("];True)");
        return sb.toString();
    }

    private String fmRepresentationOf(Object value, SimpleDateFormat timeFormat, SimpleDateFormat dateFormat) {
        if (value == null) {
            value = "";
        }
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? "True" : "False";
        }
        if (value instanceof Time) {
            return "Time(" + timeFormat.format(value) + ")";
        }
        if (value instanceof Date) {
            return "Date(" + dateFormat.format(value) + ")";
        }
        if (value instanceof String) {
            return "\"" + this.quote(value.toString()) + "\"";
        }
        throw new IllegalArgumentException("Cannot represent " + value.getClass().getName() + " " + value + " in a LET statement");
    }

    private String quote(@NotNull String value) {
        if (value == null) {
            LetStatementFormat.$$$reportNull$$$0(1);
        }
        return value.replaceAll("\"", "\\\\\"").replaceAll("\n", "\u00b6");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "payload";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/prosc/fm/LetStatementFormat";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "format";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "quote";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

