/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.database;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;

public class StreamBlob
implements Blob {
    private final Callable<InputStream> streamFunction;
    private final long length;
    MessageDigest md;
    private StreamWrapper stream = null;

    public StreamBlob(Callable<InputStream> streamFunction, long length) {
        this.streamFunction = streamFunction;
        this.length = length;
        try {
            this.generateStream();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public StreamBlob(InputStream stream, long length) {
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        this.streamFunction = null;
        this.stream = new StreamWrapper(new DigestInputStream(stream, this.md));
        this.length = length;
    }

    private void generateStream() throws Exception {
        if (this.stream == null || this.stream.index != 0L || this.stream.closed) {
            if (this.stream != null && this.streamFunction == null) {
                if (this.stream.closed) {
                    throw new IOException("The InputStream has already been closed");
                }
                throw new IOException("The InputStream has already been read to position " + this.stream.index + "; cannot regenerate it.");
            }
            try {
                this.md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            this.stream = new StreamWrapper(new DigestInputStream(this.streamFunction.call(), this.md));
        }
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        try {
            int chunkSize;
            if (this.stream.closed || pos < this.stream.index) {
                this.generateStream();
            }
            for (long skip = pos - this.stream.index; skip > 0L; skip -= this.stream.skip(skip)) {
            }
            byte[] result = new byte[length];
            for (int bytesRead = 0; bytesRead < length; bytesRead += chunkSize) {
                chunkSize = this.stream.read(result, bytesRead, length - bytesRead);
            }
            return result;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        try {
            this.generateStream();
            return this.stream;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    public String getMD5() throws IOException {
        byte[] digest = this.md.digest();
        StringBuilder tmpHash = new StringBuilder(32);
        for (byte eachByte : digest) {
            tmpHash.append(Integer.toString((eachByte & 0xFF) + 256, 16).substring(1));
        }
        return tmpHash.toString();
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        throw new SQLFeatureNotSupportedException("Searching for patterns is not supported");
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        throw new SQLFeatureNotSupportedException("Searching for patterns is not supported");
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        throw new SQLFeatureNotSupportedException("StreamBlobs are not writeable");
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw new SQLFeatureNotSupportedException("StreamBlobs are not writeable");
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new SQLFeatureNotSupportedException("StreamBlobs are not writeable");
    }

    @Override
    public void truncate(long len) throws SQLException {
        throw new SQLFeatureNotSupportedException("StreamBlobs are not writeable");
    }

    @Override
    public void free() throws SQLException {
        try {
            if (this.stream != null) {
                this.stream.close();
            }
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        try {
            if (this.stream == null || pos < this.stream.index) {
                this.generateStream();
            }
            for (long skip = pos - this.stream.index; skip > 0L; skip -= this.stream.skip(skip)) {
            }
            return this.stream;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    class StreamWrapper
    extends FilterInputStream {
        long index;
        boolean closed;

        protected StreamWrapper(InputStream in) {
            super(in);
            this.index = 0L;
            this.closed = false;
        }

        @Override
        public int read() throws IOException {
            ++this.index;
            return super.read();
        }

        @Override
        public int read(@NotNull byte[] b) throws IOException {
            if (b == null) {
                StreamWrapper.$$$reportNull$$$0(0);
            }
            int bytesRead = super.read(b);
            this.index += (long)bytesRead;
            return bytesRead;
        }

        @Override
        public int read(@NotNull byte[] b, int off, int len) throws IOException {
            if (b == null) {
                StreamWrapper.$$$reportNull$$$0(1);
            }
            int result = super.read(b, off, len);
            this.index += (long)result;
            return result;
        }

        @Override
        public long skip(long n) throws IOException {
            long result = super.skip(n);
            this.index += result;
            return result;
        }

        @Override
        public void close() throws IOException {
            byte[] ignore = new byte[8192];
            while (StreamBlob.this.stream.read(ignore) != -1) {
            }
            this.closed = true;
            super.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/prosc/database/StreamBlob$StreamWrapper", "read"));
        }
    }
}

