/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.database;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SQLQueryBuilder {
    private WhichPart currentPart;
    private StringBuilder sql;
    private List<Object> bindings;
    private QualifierBuilder qualifierBuilder;
    private String delim;

    public SQLQueryBuilder(@NotNull String sqlPreamble, Object ... bindings) {
        if (sqlPreamble == null) {
            SQLQueryBuilder.$$$reportNull$$$0(0);
        }
        this.currentPart = WhichPart.Select;
        this.sql = new StringBuilder(128);
        this.bindings = new ArrayList<Object>();
        this.sql.append(sqlPreamble);
        this.bindings.addAll(Arrays.asList(bindings));
        this._appendWhitespace();
    }

    private void _appendWhitespace() {
        if (this.sql.length() != 0 && !Character.isWhitespace(this.sql.charAt(this.sql.length() - 1))) {
            this.sql.append(' ');
        }
    }

    private void _appendDelimOptional() {
        if (this.delim != null) {
            this.sql.append(this.delim);
        } else {
            this.delim = ", ";
        }
    }

    public SQLQueryBuilder field(@NotNull String column) {
        if (column == null) {
            SQLQueryBuilder.$$$reportNull$$$0(1);
        }
        this.currentPart.assertOn(WhichPart.Select);
        this._appendDelimOptional();
        this.sql.append(column);
        return this;
    }

    public SQLQueryBuilder from(@NotNull String tablesAndJoins) {
        if (tablesAndJoins == null) {
            SQLQueryBuilder.$$$reportNull$$$0(2);
        }
        if (this.currentPart == WhichPart.Select) {
            this.currentPart = WhichPart.From;
        }
        this.currentPart.assertOn(WhichPart.From);
        this._appendWhitespace();
        this.sql.append("FROM ");
        this.sql.append(tablesAndJoins);
        this._appendWhitespace();
        this.currentPart = WhichPart.Where;
        this.delim = null;
        return this;
    }

    private QualifierBuilder _createQualifierBuilder(LogicalOp lop) {
        if (this.currentPart.isBefore(WhichPart.Where)) {
            this.currentPart = WhichPart.Where;
            if (!this.sql.toString().toLowerCase().trim().endsWith("where")) {
                this._appendWhitespace();
                this.sql.append("WHERE ");
            }
        }
        this.currentPart.assertOn(WhichPart.Where);
        if (this.qualifierBuilder != null) {
            if (this.qualifierBuilder.op != lop) {
                throw new IllegalStateException("There is already a top-level qualifierBuilder with operator \"" + (Object)((Object)this.qualifierBuilder.op) + "\" on this builder. You must nest your \"" + (Object)((Object)lop) + "\" within this one.");
            }
            return this.qualifierBuilder;
        }
        this.qualifierBuilder = new QualifierBuilder(lop);
        return this.qualifierBuilder;
    }

    public QualifierBuilder and() {
        return this._createQualifierBuilder(LogicalOp.and);
    }

    public QualifierBuilder or() {
        return this._createQualifierBuilder(LogicalOp.or);
    }

    @NotNull
    private SQLQueryBuilder _groupOrOrder(@NotNull WhichPart newPart, @NotNull String sqlTypeString, @NotNull String orderByFragment) {
        if (newPart == null) {
            SQLQueryBuilder.$$$reportNull$$$0(3);
        }
        if (sqlTypeString == null) {
            SQLQueryBuilder.$$$reportNull$$$0(4);
        }
        if (orderByFragment == null) {
            SQLQueryBuilder.$$$reportNull$$$0(5);
        }
        this.closeCurrentQualifier();
        if (this.currentPart.isBefore(WhichPart.From)) {
            throw new IllegalArgumentException("You must specify a \"FROM\" clause first");
        }
        if (this.currentPart.isAfter(newPart)) {
            throw new IllegalArgumentException("Already added a " + (Object)((Object)this.currentPart) + ", cannot add " + (Object)((Object)newPart));
        }
        if (this.currentPart.isBefore(newPart)) {
            this.currentPart = newPart;
            this.delim = null;
            this._appendWhitespace();
            this.sql.append(sqlTypeString);
        }
        this.currentPart.assertOn(newPart);
        this._appendDelimOptional();
        this.sql.append(orderByFragment);
        SQLQueryBuilder sQLQueryBuilder = this;
        if (sQLQueryBuilder == null) {
            SQLQueryBuilder.$$$reportNull$$$0(6);
        }
        return sQLQueryBuilder;
    }

    public SQLQueryBuilder orderBy(@NotNull String orderByFragment) {
        if (orderByFragment == null) {
            SQLQueryBuilder.$$$reportNull$$$0(7);
        }
        return this._groupOrOrder(WhichPart.Order, "ORDER BY ", orderByFragment);
    }

    public SQLQueryBuilder groupBy(@NotNull String groupByFragment) {
        if (groupByFragment == null) {
            SQLQueryBuilder.$$$reportNull$$$0(8);
        }
        return this._groupOrOrder(WhichPart.Group, "GROUP BY ", groupByFragment);
    }

    public SQLQueryBuilder limit(@NotNull Object limit) {
        if (limit == null) {
            SQLQueryBuilder.$$$reportNull$$$0(9);
        }
        this._groupOrOrder(WhichPart.Limit, "LIMIT ", limit.toString());
        this.currentPart = WhichPart.Done;
        return this;
    }

    public String getSQL() {
        this.closeCurrentQualifier();
        return this.sql.toString();
    }

    public List<Object> getBindings() {
        this.closeCurrentQualifier();
        return Collections.unmodifiableList(this.bindings);
    }

    private void closeCurrentQualifier() {
        if (this.qualifierBuilder != null) {
            this.qualifierBuilder.close();
            this.qualifierBuilder = null;
        }
    }

    public void append(String s) {
        this.sql.append(s);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlPreamble";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tablesAndJoins";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPart";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlTypeString";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderByFragment";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/prosc/database/SQLQueryBuilder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupByFragment";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "limit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/prosc/database/SQLQueryBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "_groupOrOrder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "field";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "from";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "_groupOrOrder";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "orderBy";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "groupBy";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "limit";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum WhichPart {
        Select,
        From,
        Where,
        Order,
        Group,
        Limit,
        Done;


        public void assertOn(WhichPart part) {
            if (this != part) {
                throw new IllegalStateException((Object)((Object)part) + " has already been called");
            }
        }

        public boolean isBefore(WhichPart otherPart) {
            return this.compareTo(otherPart) < 0;
        }

        public boolean isAfter(WhichPart otherPart) {
            return this.compareTo(otherPart) > 0;
        }
    }

    public static enum LogicalOp {
        and,
        or;

    }

    public final class QualifierBuilder {
        private final LogicalOp op;
        private LogicalOp delim;
        private QualifierBuilder nestedQualifierBuilder;

        private QualifierBuilder(LogicalOp op) {
            this.op = op;
        }

        private void _appendDelimiterIfNecessary() {
            if (this.delim == null) {
                this.delim = this.op;
                SQLQueryBuilder.this.sql.append("(");
            } else {
                SQLQueryBuilder.this._appendWhitespace();
                SQLQueryBuilder.this.sql.append((Object)this.delim).append(" ");
            }
        }

        public QualifierBuilder where(String sqlFragment) {
            this._appendDelimiterIfNecessary();
            SQLQueryBuilder.this.sql.append(sqlFragment);
            return this;
        }

        public QualifierBuilder where(String sqlFragment, Object ... bindings) {
            this._appendDelimiterIfNecessary();
            SQLQueryBuilder.this.sql.append(sqlFragment);
            SQLQueryBuilder.this.bindings.addAll(Arrays.asList(bindings));
            return this;
        }

        public QualifierBuilder whereIn(String sqlFragment, Object[] multipleValues) {
            this._closeNestedQualifier();
            if (!sqlFragment.endsWith("IN ?") && !sqlFragment.endsWith("IN ?)")) {
                throw new IllegalArgumentException("sqlFragment should end with exact string \" IN ?\", to be replaced by IN (?, ?, ?, ?, ...). Instead, we got: " + sqlFragment);
            }
            this._appendDelimiterIfNecessary();
            if (multipleValues.length == 0) {
                SQLQueryBuilder.this.sql.append("false");
                return this;
            }
            int qIndex = sqlFragment.lastIndexOf("?");
            SQLQueryBuilder.this.sql.append(sqlFragment.substring(0, qIndex));
            SQLQueryBuilder.this.sql.append("(");
            for (int i = 0; i < multipleValues.length; ++i) {
                Object eachValue = multipleValues[i];
                if (i != 0) {
                    SQLQueryBuilder.this.sql.append(", ");
                }
                SQLQueryBuilder.this.sql.append("?");
                SQLQueryBuilder.this.bindings.add(eachValue);
            }
            if (sqlFragment.endsWith(")")) {
                SQLQueryBuilder.this.sql.append(sqlFragment.substring(qIndex + 1));
            } else {
                SQLQueryBuilder.this.sql.append(")");
            }
            return this;
        }

        @NotNull
        private QualifierBuilder _getOrCreateNestedQualifierBuilder(LogicalOp newOp) {
            this._closeNestedQualifier();
            this._appendDelimiterIfNecessary();
            this.nestedQualifierBuilder = new QualifierBuilder(newOp);
            if (this.nestedQualifierBuilder == null) {
                QualifierBuilder.$$$reportNull$$$0(0);
            }
            return this.nestedQualifierBuilder;
        }

        private void _closeNestedQualifier() {
            if (this.nestedQualifierBuilder != null) {
                this.nestedQualifierBuilder.close();
                this.nestedQualifierBuilder = null;
            }
        }

        public QualifierBuilder or() {
            return this._getOrCreateNestedQualifierBuilder(LogicalOp.or);
        }

        public QualifierBuilder and() {
            return this._getOrCreateNestedQualifierBuilder(LogicalOp.and);
        }

        private void close() {
            this._closeNestedQualifier();
            if (this.delim != null) {
                SQLQueryBuilder.this.sql.append(")");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/prosc/database/SQLQueryBuilder$QualifierBuilder", "_getOrCreateNestedQualifierBuilder"));
        }
    }
}

