/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.beanshell;

final class FunctionParameter {
    private final String name;
    private final boolean varArg;
    private final boolean optional;

    FunctionParameter(String name, boolean varArg, boolean optional) {
        this.name = name;
        this.varArg = varArg;
        this.optional = optional;
    }

    static FunctionParameter valueOf(String eachSigPart) throws IllegalArgumentException {
        eachSigPart = eachSigPart.trim();
        boolean varArg = false;
        boolean optional = false;
        if (eachSigPart.endsWith("?")) {
            eachSigPart = eachSigPart.substring(0, eachSigPart.length() - 1);
            optional = true;
        }
        if (eachSigPart.endsWith("...")) {
            eachSigPart = eachSigPart.substring(0, eachSigPart.length() - 3);
            varArg = true;
        }
        if (!eachSigPart.matches("\\w+")) {
            throw new IllegalArgumentException("Invalid parameter name '" + eachSigPart + "': parameter names can only contain alphanumeric characters and underscores");
        }
        if (Character.isDigit(eachSigPart.charAt(0))) {
            throw new IllegalArgumentException("Invalid parameter name '" + eachSigPart + "': parameter names cannot start with a digit");
        }
        return new FunctionParameter(eachSigPart, varArg, optional);
    }

    public String getName() {
        return this.name;
    }

    public boolean isVarArg() {
        return this.varArg;
    }

    public boolean isOptional() {
        return this.optional;
    }
}

