/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.shared;

import com.prosc.shared.CallableWithRetry;
import com.prosc.shared.Retry;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class Retry2<T, E1 extends Exception, E2 extends Exception> {
    private static final Logger log = Logger.getLogger(Retry.class.getName());
    private int maxTries;
    private int startingDelayMilliseconds;

    public Retry2(int maxTries, int startingDelayMilliseconds) {
        this.maxTries = maxTries;
        this.startingDelayMilliseconds = startingDelayMilliseconds;
    }

    public final T doTask(CallableWithRetry<T> callable, Class<E1> expectedExceptionType1, Class<E2> expectedExceptionType2) throws E1, E2 {
        int delay = 0;
        int attempt = 1;
        while (true) {
            try {
                T result = callable.call(attempt, this.maxTries);
                if (attempt > 1) {
                    String attemptName = attempt == 2 ? "2nd" : (attempt == 3 ? "3rd" : String.valueOf(attempt) + "th");
                    log.info("Task succeeded on the " + attemptName + " attempt");
                }
                return result;
            }
            catch (Exception e) {
                try {
                    if (attempt < this.maxTries && (expectedExceptionType1.isAssignableFrom(e.getClass()) && this.shouldRetry1(e) || expectedExceptionType2.isAssignableFrom(e.getClass()) && this.shouldRetry2(e))) {
                        delay = delay == 0 ? this.startingDelayMilliseconds : (delay *= 2);
                        log.info("Task failed; retry #" + ++attempt + " in " + delay + " milliseconds. Exception: " + e.toString());
                        try {
                            Thread.sleep(delay);
                        }
                        catch (InterruptedException e1) {
                            Thread.currentThread().interrupt();
                            throw e;
                        }
                        continue;
                    }
                    throw e;
                }
                catch (Exception e2) {
                    if (expectedExceptionType1.isAssignableFrom(e2.getClass())) {
                        throw e2;
                    }
                    if (expectedExceptionType2.isAssignableFrom(e2.getClass())) {
                        throw e2;
                    }
                    if (e2 instanceof RuntimeException) {
                        throw (RuntimeException)e2;
                    }
                    throw new RuntimeException(e2);
                }
            }
            break;
        }
    }

    protected boolean shouldRetry1(@NotNull E1 e) {
        if (e == null) {
            Retry2.$$$reportNull$$$0(0);
        }
        return true;
    }

    protected boolean shouldRetry2(@NotNull E2 e) {
        if (e == null) {
            Retry2.$$$reportNull$$$0(1);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/prosc/shared/Retry2";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldRetry1";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldRetry2";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

