/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.shared;

import java.util.Calendar;
import java.util.GregorianCalendar;

public class BusinessCalendar
extends GregorianCalendar {
    @Override
    public int compareTo(Calendar anotherCalendar) {
        return (int)(this.getTimeInMillis() - anotherCalendar.getTimeInMillis());
    }

    @Override
    public void add(int field, int amount) {
        switch (field) {
            case 7: {
                int increment;
                int n = increment = amount >= 0 ? 1 : -1;
                while (amount != 0) {
                    super.add(field, increment);
                    while (this.isNonBusinessDay()) {
                        super.add(field, increment);
                    }
                    amount -= increment;
                }
                break;
            }
            default: {
                super.add(field, amount);
            }
        }
        this.adjustToBusinessDay(amount >= 0);
    }

    @Override
    public void roll(int field, boolean up) {
        super.roll(field, up);
    }

    @Override
    public int getMinimum(int field) {
        return super.getMinimum(field);
    }

    @Override
    public int getMaximum(int field) {
        return super.getMinimum(field);
    }

    @Override
    public int getGreatestMinimum(int field) {
        return super.getGreatestMinimum(field);
    }

    @Override
    public int getLeastMaximum(int field) {
        return super.getLeastMaximum(field);
    }

    private void adjustToBusinessDay(boolean b) {
        while (this.isNonBusinessDay()) {
            super.add(5, b ? 1 : -1);
        }
    }

    private boolean isNonBusinessDay() {
        return this.get(7) == 7 || this.get(7) == 1;
    }
}

