/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class ZipArchiver
implements FileVisitor<Path> {
    private static final Logger log = Logger.getLogger(ZipArchiver.class.getName());
    private static final String JAR_FILE_PROTOCOL = "jar:file:";
    private static final HashMap<String, String> options = new HashMap();
    private Path root;
    private Path filePath;
    private Path zipFilePath;

    public ZipArchiver(@NotNull Path zipFilePath) {
        if (zipFilePath == null) {
            ZipArchiver.$$$reportNull$$$0(0);
        }
        this.zipFilePath = zipFilePath;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        Path to = this.root.resolve(this.filePath.relativize(dir).toString());
        Files.createDirectories(to, new FileAttribute[0]);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        Path to = this.root.resolve(this.filePath.relativize(file).toString());
        Files.copy(file, to, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        log.log(Level.SEVERE, "Visit to file " + file.toString() + " failed", exc);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        if (exc != null) {
            log.log(Level.SEVERE, "An error occurred after visiting directory " + dir.toString(), exc);
        }
        return FileVisitResult.CONTINUE;
    }

    public void zipFilePaths(Path ... filePathsToZip) throws IOException {
        if (filePathsToZip == null) {
            ZipArchiver.$$$reportNull$$$0(1);
        }
        try (FileSystem zipFileSystem = FileSystems.newFileSystem(URI.create(JAR_FILE_PROTOCOL + this.zipFilePath.toString().replace("\\", "/")), options);){
            this.root = zipFileSystem.getPath("/", new String[0]);
            Path[] pathArray = filePathsToZip;
            int n = pathArray.length;
            for (int i = 0; i < n; ++i) {
                Path filePath;
                this.filePath = filePath = pathArray[i];
                Files.walkFileTree(filePath, this);
            }
        }
    }

    public void zipFiles(File ... filesToZip) throws IOException {
        if (filesToZip == null) {
            ZipArchiver.$$$reportNull$$$0(2);
        }
        try (FileSystem zipFileSystem = FileSystems.newFileSystem(URI.create(JAR_FILE_PROTOCOL + this.zipFilePath.toString().replace("\\", "/")), options);){
            this.root = zipFileSystem.getPath("/", new String[0]);
            for (File file : filesToZip) {
                this.filePath = file.toPath();
                Files.walkFileTree(this.filePath, this);
            }
        }
    }

    public void zipFolder(@NotNull Path directoryToZip, boolean skipRootDirectory) throws IOException {
        if (directoryToZip == null) {
            ZipArchiver.$$$reportNull$$$0(3);
        }
        try (FileSystem zipFileSystem = FileSystems.newFileSystem(URI.create(JAR_FILE_PROTOCOL + this.zipFilePath.toString().replace("\\", "/")), options);){
            this.root = skipRootDirectory ? zipFileSystem.getPath("/", new String[0]) : zipFileSystem.getPath("/", directoryToZip.getFileName().toString());
            this.filePath = directoryToZip;
            Files.walkFileTree(this.filePath, this);
        }
    }

    static {
        options.put("create", "true");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipFilePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePathsToZip";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToZip";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryToZip";
                break;
            }
        }
        objectArray2[1] = "com/prosc/io/ZipArchiver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "zipFilePaths";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "zipFiles";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "zipFolder";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

