/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class SerializeUtils {
    public static byte[] serialize(Object o, boolean gzip) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStream wrapped = gzip ? new GZIPOutputStream(baos) : baos;
        ObjectOutputStream out = new ObjectOutputStream(wrapped);
        out.writeObject(o);
        out.close();
        byte[] bytes = baos.toByteArray();
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserialize(byte[] bytes, boolean gzip) throws IOException, ClassNotFoundException {
        try (ObjectInputStream in = null;){
            InputStream wrapped = new ByteArrayInputStream(bytes);
            if (gzip) {
                wrapped = new GZIPInputStream(wrapped);
            }
            in = new ObjectInputStream(wrapped);
            Object object = in.readObject();
            return object;
        }
    }

    public static <E> E deepCopy(E copyMe) {
        try {
            return (E)SerializeUtils.deserialize(SerializeUtils.serialize(copyMe, true), true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

