/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import com.prosc.shared.StringUtils;
import java.nio.charset.Charset;

public class ProcessExecutionException
extends Exception {
    private byte[] data;
    private int exitStatus;

    public ProcessExecutionException(byte[] data, String errorMessage, int exitStatus) {
        super(errorMessage);
        this.data = data;
        this.exitStatus = exitStatus;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getExitStatus() {
        return this.exitStatus;
    }

    public Integer getErrorCode() {
        String errorCodeString = StringUtils.textBetween(this.getMessage(), "Error: ", StringUtils.CR);
        if (errorCodeString == null) {
            return null;
        }
        int mark1 = errorCodeString.indexOf(32);
        if (mark1 != -1) {
            errorCodeString = errorCodeString.substring(0, mark1).trim();
        }
        return Integer.valueOf(errorCodeString);
    }

    @Override
    public String getMessage() {
        String result = super.getMessage();
        if (StringUtils.isEmpty(result)) {
            result = new String(this.data, Charset.forName("utf-8"));
        }
        return result;
    }
}

