/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public enum FileType {
    unknown("application/unknown", "dat"),
    binary("application/octet-stream", "bin", "exe"),
    gzip("application/gzip", "gzip"),
    png("image/png", "png"),
    jpeg("image/jpeg", "jpg", "jpeg"),
    gif("image/gif", "gif"),
    tiff("image/tiff", "tif", "tiff"),
    html("text/html", "htm", "html"),
    css("text/css", "css"),
    scss("text/x-scss", "scss"),
    javascript("application/javascript", "js"),
    plaintext("text/plain", "txt"),
    json("application/json", "json"),
    map("application/x-navimap", "map"),
    markdown("text/markdown", "md"),
    pdf("application/pdf", "pdf"),
    doc("application/msword", "doc"),
    docx("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "docx", "docm", "dotx", "dotm"),
    xlsx("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "xlsx"),
    pptx("application/vnd.openxmlformats-officedocument.presentationml.presentation", "pptx"),
    zip("application/zip", "zip"),
    jar("application/java-archive", "jar"),
    opentypefont("application/vnd.ms-fontobject", "eot"),
    outlinefont("application/font-sfnt ", "otf"),
    svg("image/svg+xml", "svg"),
    truetypefont("application/font-sfnt", "ttf"),
    woff("application/font-woff", "woff"),
    woff2("font/woff2", "woff2");

    private static final Logger log;
    private String mimeType;
    private List<String> extensions;

    private FileType(String mimeType, String ... extensions) {
        this.mimeType = mimeType;
        this.extensions = Arrays.asList(extensions);
    }

    public String getPrimaryExtension() {
        return this.extensions.get(0);
    }

    public String getMimeType() {
        return this.mimeType;
    }

    @NotNull
    public static FileType fileTypeForFileName(String filename) {
        String suffix = filename.substring(filename.lastIndexOf(46) + 1);
        for (FileType fileType : FileType.values()) {
            if (!fileType.extensions.contains(suffix)) continue;
            FileType fileType2 = fileType;
            if (fileType2 == null) {
                FileType.$$$reportNull$$$0(0);
            }
            return fileType2;
        }
        log.warning("Could not determine file type for '" + filename + "'; will use binary");
        FileType fileType = binary;
        if (fileType == null) {
            FileType.$$$reportNull$$$0(1);
        }
        return fileType;
    }

    static {
        log = Logger.getLogger(FileType.class.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/prosc/io/FileType", "fileTypeForFileName"));
    }
}

