/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fx;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import javafx.concurrent.Task;

public abstract class OutputStreamTask
extends Task {
    private int nWritten = 0;
    private int size = 0;
    OutputStream out;

    public OutputStream getOutputStream() {
        return this.out;
    }

    public OutputStreamTask(OutputStream out, int size) {
        this.out = out;
        this.size = size;
    }

    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.nWritten;
        this.updateProgress(this.nWritten, this.size);
        if (this.isCancelled()) {
            InterruptedIOException exc = new InterruptedIOException("progress");
            exc.bytesTransferred = this.nWritten;
            throw exc;
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.nWritten += len - off;
        this.updateProgress(this.nWritten, this.size);
        if (this.isCancelled()) {
            InterruptedIOException exc = new InterruptedIOException("progress");
            exc.bytesTransferred = this.nWritten;
            throw exc;
        }
    }

    public void write(byte[] b) throws IOException {
        this.out.write(b.length);
        this.nWritten += b.length;
        this.updateProgress(this.nWritten, this.size);
        if (this.isCancelled()) {
            InterruptedIOException exc = new InterruptedIOException("progress");
            exc.bytesTransferred = this.nWritten;
            throw exc;
        }
    }

    public void close() throws IOException {
        this.out.close();
    }
}

