/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fx;

import com.prosc.Platform;
import com.sun.javafx.tk.TKStage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javafx.stage.Stage;
import javafx.stage.Window;

public class NativeWindowManager {
    public static final Logger log = Logger.getLogger(NativeWindowManager.class.getName());
    public static int NATIVE_WINDOW_BELOW = 0;
    public static int NATIVE_WINDOW_ABOVE = 1;

    public static native void _enableWindowListener(long var0);

    public static void enableWindowListener(Window window) {
        if (Platform.isWin()) {
            NativeWindowManager._enableWindowListener(NativeWindowManager.getFxWindowHandle(window));
        }
    }

    public static native void _nativeAppToFront(boolean var0);

    public static void nativeAppToFront(boolean force) {
        if (Platform.isMac()) {
            NativeWindowManager._nativeAppToFront(force);
        }
    }

    public static void setForegroundWindow(Window window) {
        if (Platform.isWin()) {
            NativeWindowManager._setForegroundWindow(0L);
        }
    }

    public static native void _setForegroundWindow(long var0);

    public static native void _nativeAppToBack();

    public static void nativeAppToBack() {
        if (Platform.isMac()) {
            NativeWindowManager._nativeAppToBack();
        }
    }

    public static native void nativeWindowPosition(int var0, int var1);

    public static native boolean nativeWindowShouldHide();

    public static native String nativeFileChooser(String var0, boolean var1, boolean var2, boolean var3);

    public static native void nativeWindowSetHidingBehavior();

    public static void nativeWindowHide(Stage stage) {
        NativeWindowManager._nativeWindowHide(NativeWindowManager.getFxWindowHandle((Window)stage));
    }

    private static native void _nativeWindowHide(long var0);

    static long getFxWindowHandle(Window window) {
        try {
            Method tkStageGetter;
            try {
                tkStageGetter = window.getClass().getSuperclass().getDeclaredMethod("getPeer", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                tkStageGetter = window.getClass().getMethod("impl_getPeer", new Class[0]);
            }
            tkStageGetter.setAccessible(true);
            TKStage tkStage = (TKStage)tkStageGetter.invoke((Object)window, new Object[0]);
            Method getPlatformWindow = tkStage.getClass().getDeclaredMethod("getPlatformWindow", new Class[0]);
            getPlatformWindow.setAccessible(true);
            Object platformWindow = getPlatformWindow.invoke((Object)tkStage, new Object[0]);
            Method getNativeHandle = platformWindow.getClass().getMethod("getNativeHandle", new Class[0]);
            getNativeHandle.setAccessible(true);
            Object nativeHandle = getNativeHandle.invoke(platformWindow, new Object[0]);
            return (Long)nativeHandle;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

