/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fx;

import com.prosc.fx.StartFinishTask;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class InputStreamTask<V>
extends StartFinishTask<V> {
    public static final Logger log = Logger.getLogger(InputStreamTask.class.getName());
    private int nread = 0;
    private int size;
    private InputStream in;

    public InputStream getInputStream() {
        return this.in;
    }

    public InputStreamTask(InputStream in) {
        this.in = in;
        try {
            this.size = in.available();
        }
        catch (IOException ioe) {
            this.size = 0;
        }
    }

    public InputStreamTask(InputStream in, int size) {
        this(in);
        this.size = size;
    }

    public int read() throws IOException {
        int c = this.in.read();
        if (c >= 0) {
            this.updateProgress(++this.nread, this.size);
        }
        this.checkCancelled();
        return c;
    }

    public int read(byte[] b) throws IOException {
        int nr = this.in.read(b);
        if (nr > 0) {
            this.updateProgress(this.nread += nr, this.size);
        }
        this.checkCancelled();
        return nr;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int nr = this.in.read(b, off, len);
        if (nr > 0) {
            this.updateProgress(this.nread += nr, this.size);
        }
        this.checkCancelled();
        return nr;
    }

    public long skip(long n) throws IOException {
        long nr = this.in.skip(n);
        if (nr > 0L) {
            this.nread = (int)((long)this.nread + nr);
            this.updateProgress(this.nread, this.size);
        }
        this.checkCancelled();
        return nr;
    }

    @Override
    public void close() throws IOException {
        try {
            this.in.close();
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "An error occurred while closing an InputStreamTask", e);
            throw e;
        }
        finally {
            this.checkCancelled();
            super.close();
        }
    }

    public synchronized void reset() throws IOException {
        this.in.reset();
        this.nread = this.size - this.in.available();
        this.updateProgress(this.nread, this.size);
        this.checkCancelled();
    }

    private void checkCancelled() throws InterruptedIOException {
        if (this.isCancelled()) {
            InterruptedIOException exc = new InterruptedIOException("progress");
            exc.bytesTransferred = this.nread;
            this.setException(exc);
        }
    }
}

