/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.format;

import com.prosc.shared.StringUtils;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RelativeDateFormat
extends Format {
    private final String pastTerm = "ago";
    private String futureTerm = "from now";

    @Override
    public StringBuffer format(Object obj, @NotNull StringBuffer toAppendTo, @NotNull FieldPosition pos) {
        if (toAppendTo == null) {
            RelativeDateFormat.$$$reportNull$$$0(0);
        }
        if (pos == null) {
            RelativeDateFormat.$$$reportNull$$$0(1);
        }
        String str = this.formatWorker((Date)obj);
        pos.setEndIndex(str.length());
        return toAppendTo.append(str);
    }

    private String formatWorker(Date date) {
        if (date == null) {
            return "";
        }
        long now = System.currentTimeMillis();
        long when = date.getTime();
        int seconds = (int)Math.round((double)(when - now) / 1000.0);
        boolean inThePast = seconds < 0;
        String term = StringUtils.emptyStringForNull(inThePast ? this.pastTerm : this.futureTerm);
        if (!StringUtils.isEmpty(term) && !Character.isWhitespace(term.charAt(0))) {
            term = " " + term;
        }
        if ((seconds = Math.abs(seconds)) < 60) {
            return seconds == 1 ? "one second " + term : this.numFormat(seconds) + " seconds" + term;
        }
        if (seconds < 120) {
            return "a minute" + term;
        }
        int minutes = seconds / 60;
        if (seconds < 2700) {
            return minutes + " minutes" + term;
        }
        if (seconds < 5400) {
            return "an hour" + term;
        }
        int hours = minutes / 60;
        if (seconds < 86400) {
            return hours + " hours" + term;
        }
        if (seconds < 172800) {
            return inThePast ? "yesterday" : "tomorrow";
        }
        int days = hours / 24;
        if (seconds < 2592000) {
            return days + " days" + term;
        }
        int months = days / 30;
        if (seconds < 31104000) {
            return months <= 1 ? "one month" + term : this.numFormat(months) + " months" + term;
        }
        int years = days / 365;
        return years <= 1 ? "one year" + term : this.numFormat(years) + " years" + term;
    }

    private String numFormat(int howMany) {
        switch (howMany) {
            case 0: {
                return "zero";
            }
            case 1: {
                return "one";
            }
            case 2: {
                return "two";
            }
            case 3: {
                return "three";
            }
            case 4: {
                return "four";
            }
            case 5: {
                return "five";
            }
            case 6: {
                return "six";
            }
            case 7: {
                return "seven";
            }
            case 8: {
                return "eight";
            }
            case 9: {
                return "nine";
            }
            case 10: {
                return "ten";
            }
            case 11: {
                return "eleven";
            }
            case 12: {
                return "twelve";
            }
            case 13: {
                return "thirteen";
            }
        }
        return String.valueOf(howMany);
    }

    @Override
    public Object parseObject(String source, @NotNull ParsePosition pos) {
        if (pos == null) {
            RelativeDateFormat.$$$reportNull$$$0(2);
        }
        throw new UnsupportedOperationException("RelativeDateFormat does not support parsing text input");
    }

    public void setFutureTerm(@Nullable String futureTerm) {
        this.futureTerm = futureTerm;
    }

    public String getFutureTerm() {
        return this.futureTerm;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toAppendTo";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
        }
        objectArray2[1] = "com/prosc/format/RelativeDateFormat";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "format";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "parseObject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

