/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.format;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FlexibleDateFormat
extends DateFormat {
    public static final String SHORT = "SHORT";
    public static final String MEDIUM = "MEDIUM";
    public static final String LONG = "LONG";
    private DateFormat[] parsers;
    private int currentIndex;
    private DateFormat formatObject;

    public FlexibleDateFormat() {
        this(new String[]{"M/d/yy", "M/d/yyyy", SHORT, MEDIUM, LONG, "MMMMM dd, yyyy", "MM.dd.yy", "MMMMMddyyyy", "yyyy-MM-dd", "EEE MMM dd HH:mm:ss zzz yyyy", "E, d MMM yyyy HH:mm:ss z"}, "M/d/yyyy");
    }

    public FlexibleDateFormat(String ... dateFormatStrings) {
        this(dateFormatStrings, dateFormatStrings[0]);
    }

    public FlexibleDateFormat(String[] parseStrings, String formatString) {
        if (parseStrings == null || parseStrings.length == 0) {
            throw new IllegalArgumentException("No parseStrings specified.");
        }
        this.parsers = new SimpleDateFormat[parseStrings.length];
        for (int i = 0; i < parseStrings.length; ++i) {
            String eachString = parseStrings[i];
            DateFormat eachFormat = eachString.equals(SHORT) ? DateFormat.getDateInstance(3) : (eachString.equals(MEDIUM) ? DateFormat.getDateInstance(2) : (eachString.equals(LONG) ? DateFormat.getDateInstance(1) : new SimpleDateFormat(eachString)));
            this.parsers[i] = eachFormat;
        }
        this.formatObject = new SimpleDateFormat(formatString);
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        return this.formatObject.format(date, toAppendTo, fieldPosition);
    }

    @Override
    public Date parse(String source, ParsePosition pos) {
        try {
            Date result = this.tryToParseDate(source);
            if (pos != null) {
                pos.setIndex(pos.getIndex() + source.length());
            }
            return result;
        }
        catch (ParseException e) {
            return null;
        }
    }

    @Override
    public Date parse(String source) throws ParseException {
        return this.tryToParseDate(source);
    }

    private Date tryToParseDate(String dateString) throws ParseException {
        if (this.currentIndex > 0) {
            try {
                return this.parsers[this.currentIndex].parse(dateString);
            }
            catch (ParseException e) {
                this.currentIndex = 0;
            }
        }
        ParseException lastException = null;
        for (int i = 0; i < this.parsers.length; ++i) {
            DateFormat eachFormat = this.parsers[i];
            try {
                Date result = eachFormat.parse(dateString);
                this.currentIndex = i;
                return result;
            }
            catch (ParseException e) {
                lastException = e;
                continue;
            }
        }
        throw lastException;
    }
}

