/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit.types;

import com.prosc.fmkit.CodeToParent;
import com.prosc.fmkit.JackInputStream;
import com.prosc.fmkit.PluginContext;
import com.prosc.fmkit.types.Converter;
import com.prosc.fmkit.types.FMBinary;
import com.prosc.fmkit.types.FMBinaryInterface;
import com.prosc.fmkit.types.FMNumber;
import com.prosc.fmkit.types.FMText;
import com.prosc.fmkit.types.FMType;
import com.prosc.fmkit.types.FileReference;
import java.io.DataInputStream;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.logging.Logger;

public class FMData {
    private static final Logger log = Logger.getLogger(FMData.class.getName());
    public static final int kDTInvalid = 0;
    public static final int kDTText = 1;
    public static final int kDTNumber = 2;
    public static final int kDTDate = 3;
    public static final int kDTTime = 4;
    public static final int kDTTimeStamp = 5;
    public static final int kDTBinary = 6;
    public static final int kDTBoolean = 7;
    private static long FM_EPOCH_OFFSET = 62135683200000L;
    private long cDataToken;

    protected static void registerConverters() {
        FMType.addConverter(new FMDataConverter());
    }

    public FMData(long cDataToken, Thread mainThread) {
        this.cDataToken = cDataToken;
    }

    public FMData(PluginContext context) {
        this.cDataToken = this._createEmptyData(context);
    }

    private long _createEmptyData(PluginContext context) {
        return context.callback(CodeToParent.createEmptyFmData, null, DataInputStream::readLong);
    }

    public long getLongData(PluginContext context) {
        return context.callback(CodeToParent.getLongData, out -> out.writeLong(this.cDataToken), DataInputStream::readLong);
    }

    public double getDoubleData(PluginContext context) {
        return context.callback(CodeToParent.getDoubleData, out -> out.writeLong(this.cDataToken), DataInputStream::readDouble);
    }

    public long getCToken() {
        return this.cDataToken;
    }

    public void setStringData(PluginContext context, String data) {
        if (data == null) {
            data = "";
        }
        String finalData = data;
        context.callback(CodeToParent.setStringData, out -> {
            out.writeLong(this.cDataToken);
            out.writeUTF16String(finalData);
        }, null);
    }

    public String getStringData(PluginContext context) {
        return this.getStringData(context, true);
    }

    public String getStringDataWithConvertedNewlines(PluginContext context) {
        String s = this.getStringData(context);
        return s == null ? null : s.replace('\r', '\n');
    }

    public String getStringData(PluginContext context, boolean checkFmThread) {
        return this._getStringData(context, this.cDataToken);
    }

    public String toString() {
        return super.toString();
    }

    private String _getStringData(PluginContext context, long cDataToken) {
        if (context == null) {
            throw new IllegalArgumentException("Null plugin context");
        }
        return context.callback(CodeToParent.getFmDataAsString, out -> out.writeLong(cDataToken), JackInputStream::readUTF16String);
    }

    public long getDateTimeValue(PluginContext context) {
        long secondsSinceFmEpoch = context.callback(CodeToParent.getDateTimeDataAsSeconds, out -> out.writeLong(this.cDataToken), DataInputStream::readLong);
        if (secondsSinceFmEpoch == 0L) {
            return 0L;
        }
        long millisSinceFmEpoch = secondsSinceFmEpoch * 1000L;
        long millisSinceUnixEpoch = millisSinceFmEpoch - FM_EPOCH_OFFSET;
        return millisSinceUnixEpoch - (long)TimeZone.getDefault().getOffset(millisSinceUnixEpoch);
    }

    public void setDateTimeValue(long date, PluginContext context) {
        Calendar sharedCalendar = Calendar.getInstance();
        sharedCalendar.setTimeInMillis(date);
        int year = sharedCalendar.get(1);
        int month = sharedCalendar.get(2) + 1;
        int day = sharedCalendar.get(5);
        int hour = sharedCalendar.get(11);
        int minute = sharedCalendar.get(12);
        int second = sharedCalendar.get(13);
        context.callback(CodeToParent.setDateTimeData, out -> {
            out.writeLong(this.cDataToken);
            out.writeInt(year);
            out.writeInt(month);
            out.writeInt(day);
            out.writeInt(hour);
            out.writeInt(minute);
            out.writeInt(second);
        }, null);
    }

    public FMText getFMText(PluginContext context) {
        return new FMText(this._getFMText(this.cDataToken, context), this);
    }

    private long _getFMText(long cDataToken, PluginContext context) {
        return context.callback(CodeToParent.getFmDataAsFmText, out -> out.writeLong(cDataToken), DataInputStream::readLong);
    }

    public FMBinaryInterface getFMBinary(PluginContext context) {
        String stringData = this.getStringData(context, false);
        if (stringData != null && FileReference.isValidReferenceString(stringData)) {
            log.fine("stringData " + stringData + " is a REFERENCE");
            return new FileReference(stringData, context);
        }
        if (this.getNativeType(context) == 6) {
            log.fine("stringData " + stringData + " is a STORED CONTAINER");
            return new FMBinary(this._getFMBinary(this.cDataToken, context), this);
        }
        return null;
    }

    private long _getFMBinary(long cDataToken, PluginContext context) {
        return context.callback(CodeToParent.getFmDataAsFmBinary, out -> out.writeLong(cDataToken), DataInputStream::readLong);
    }

    public void setFMBinary(FMBinary binary, PluginContext context) {
        this._setFMBinary(this.cDataToken, binary.cToken(), context);
    }

    private void _setFMBinary(long cDataToken, long cBinaryToken, PluginContext context) {
        context.callback(CodeToParent.writeFmBinaryToFmData, out -> {
            out.writeLong(cDataToken);
            out.writeLong(cBinaryToken);
        }, null);
    }

    public boolean isEmpty(PluginContext context) {
        return context.callback(CodeToParent.isEmpty, out -> out.writeLong(this.cDataToken), DataInputStream::readBoolean);
    }

    public int getNativeType(PluginContext context) {
        return context.callback(CodeToParent.getNativeType, out -> out.writeLong(this.cDataToken), DataInputStream::readInt);
    }

    public Object getFMType(PluginContext context) {
        int nativeType = this.getNativeType(context);
        switch (nativeType) {
            case 0: {
                throw new IllegalStateException("Invalid data type");
            }
            case 2: {
                return new FMNumber(this.getDoubleData(context));
            }
            case 6: {
                return this.getFMBinary(context);
            }
            case 1: {
                return this.getFMText(context);
            }
        }
        return this.getFMText(context);
    }

    private static class FMDataConverter
    implements Converter {
        private FMDataConverter() {
        }

        @Override
        public boolean canConvertTo(Class targetClass) {
            return targetClass == FMData.class;
        }

        @Override
        public Object convertData(FMData param, Class targetClass, PluginContext context) {
            return param.isEmpty(context) ? null : param;
        }
    }
}

