/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;

public class VersionInfo {
    public final byte licenseVersion;
    public final byte minimumLicenseVersion;
    public final String stringVersion;
    public final Date majorReleaseDate;

    public VersionInfo(byte licenseVersion, String stringVersion, String majorReleaseDateString) {
        this(licenseVersion, licenseVersion, stringVersion, majorReleaseDateString);
    }

    public VersionInfo(byte licenseVersion, byte minimumLicenseVersion, String stringVersion, String majorReleaseDateString) {
        if (stringVersion == null) {
            throw new IllegalArgumentException("stringVersion must not be null.");
        }
        if (majorReleaseDateString == null) {
            throw new IllegalArgumentException("majorReleaseDate must not be null.");
        }
        this.licenseVersion = licenseVersion;
        this.minimumLicenseVersion = minimumLicenseVersion;
        this.stringVersion = stringVersion;
        try {
            this.majorReleaseDate = DateFormat.getDateInstance(3, Locale.US).parse(majorReleaseDateString);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public VersionInfo(byte licenseVersion, byte minimumLicenseVersion, String stringVersion, Date majorReleaseDate) {
        if (stringVersion == null) {
            throw new IllegalArgumentException("stringVersion must not be null.");
        }
        if (majorReleaseDate == null) {
            throw new IllegalArgumentException("majorReleaseDate must not be null.");
        }
        this.licenseVersion = licenseVersion;
        this.minimumLicenseVersion = minimumLicenseVersion;
        this.stringVersion = stringVersion;
        this.majorReleaseDate = majorReleaseDate;
    }

    public String toString() {
        return this.stringVersion;
    }

    public boolean isAtLeast(String minimumRequiredVersion) {
        return minimumRequiredVersion.compareTo(this.stringVersion) <= 0;
    }
}

