/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit;

import com.prosc.fmkit.ProscPlugin;
import com.prosc.fmkit.RegisterablePlugin;
import com.prosc.license.client.Registration;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;

public class RegisterDialogPane
extends DialogPane {
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private Label productVersionLabel;
    @FXML
    private Label licenseTypeLabel;
    @FXML
    private Label registeredToLabel;
    @FXML
    private TextField licenseKeyField;
    @FXML
    private TextField registeredToField;
    @FXML
    private TextField emailAddress;
    @FXML
    private TextField phoneNumber;
    @FXML
    private TextArea problemDescription;
    @FXML
    private CheckBox includeLogFile;
    @FXML
    private Label errorText;
    public static final Logger log = Logger.getLogger(RegisterDialogPane.class.getName());
    private Button questionButton;
    private Button registerButton;
    private Button bugButton;
    private Button cancelButton;
    private ProscPlugin plugin;
    private Registration registration;
    private boolean displayLicenseKey;

    @FXML
    void initialize() {
        assert (this.productVersionLabel != null) : "fx:id=\"productVersionLabel\" was not injected: check your FXML file 'RegisterDialogController.fxml'.";
        assert (this.licenseTypeLabel != null) : "fx:id=\"licenseTypeLabel\" was not injected: check your FXML file 'RegisterDialogController.fxml'.";
        assert (this.registeredToLabel != null) : "fx:id=\"registeredToLabel\" was not injected: check your FXML file 'RegisterDialogController.fxml'.";
        assert (this.licenseKeyField != null) : "fx:id=\"licenseKeyField\" was not injected: check your FXML file 'RegisterDialogController.fxml'.";
        assert (this.registeredToField != null) : "fx:id=\"registeredToField\" was not injected: check your FXML file 'RegisterDialogController.fxml'.";
        assert (this.emailAddress != null) : "fx:id=\"emailAddress\" was not injected: check your FXML file 'RegisterDialogController.fxml'.";
        assert (this.phoneNumber != null) : "fx:id=\"phoneNumber\" was not injected: check your FXML file 'RegisterDialogController.fxml'.";
        assert (this.problemDescription != null) : "fx:id=\"problemDescription\" was not injected: check your FXML file 'RegisterDialogController.fxml'.";
        assert (this.includeLogFile != null) : "fx:id=\"includeLogFile\" was not injected: check your FXML file 'RegisterDialogController.fxml'.";
        assert (this.errorText != null) : "fx:id=\"errorText\" was not injected: check your FXML file 'RegisterDialogController.fxml'.";
        this.onInitialize();
    }

    RegisterDialogPane(ProscPlugin plugin, Registration registration, boolean displayLicenseKey) {
        this.plugin = plugin;
        this.registration = registration;
        this.displayLicenseKey = displayLicenseKey;
        String fxmlName = RegisterDialogPane.class.getSimpleName() + ".fxml";
        URL resource = RegisterDialogPane.class.getResource(fxmlName);
        if (resource == null) {
            throw new IllegalStateException("Could not load fxml to generate user interface; no resource exists at " + fxmlName);
        }
        ResourceBundle bundle = ResourceBundle.getBundle(RegisterDialogPane.class.getCanonicalName());
        FXMLLoader fxmlLoader = new FXMLLoader(resource, bundle);
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setController((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public String getLicenseKeyFieldValue() {
        return this.licenseKeyField.getText();
    }

    public String getRegisteredToFieldValue() {
        return this.registeredToField.getText();
    }

    public void setLicenseKeyFieldValue(String value) {
        this.licenseKeyField.setText(value);
    }

    public void setRegisteredToFieldValue(String value) {
        this.registeredToField.setText(value);
    }

    public void showErrorMessage(String errorMessage) {
        this.errorText.setText(errorMessage);
        this.errorText.setVisible(true);
    }

    private void hideErrorMessage() {
        this.errorText.setText("");
        this.errorText.setVisible(false);
    }

    void askQuestion(ActionEvent event) {
        String supportUrl = this.plugin.getSupportUrl();
        if (supportUrl != null && Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(new URI(supportUrl));
            }
            catch (IOException | URISyntaxException e) {
                log.log(Level.WARNING, "An error occurred trying to open plug-in support URL in a browser", e);
            }
        }
    }

    public boolean isRegisteringPlugin() {
        return this.registerButton.isArmed();
    }

    public boolean isSubmittingBugReport() {
        return this.bugButton.isArmed();
    }

    public void reportBug() throws IOException, IllegalArgumentException {
        this.validateBugReportForm();
        if (this.registration != null) {
            this.plugin.reportProblem(this.emailAddress.getText(), this.problemDescription.getText(), this.phoneNumber.getText(), this.registration.getLicense().getOrderID(), this.registration.getLicenseInfo(), this.includeLogFile.isSelected());
        } else {
            this.plugin.reportProblem(this.emailAddress.getText(), this.problemDescription.getText(), this.phoneNumber.getText(), null, null, this.includeLogFile.isSelected());
        }
    }

    private void onInitialize() {
        ButtonType bug = new ButtonType("Submit Bug Report", this.plugin instanceof RegisterablePlugin ? ButtonBar.ButtonData.OTHER : ButtonBar.ButtonData.OK_DONE);
        ButtonType cancel = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
        ButtonType ask = new ButtonType("Help", ButtonBar.ButtonData.HELP);
        if (this.plugin instanceof RegisterablePlugin) {
            ButtonType ok = new ButtonType("Register", ButtonBar.ButtonData.OK_DONE);
            this.getButtonTypes().addAll((Object[])new ButtonType[]{ok, cancel, ask, bug});
            this.registerButton = (Button)this.lookupButton(ok);
            ButtonBar.setButtonUniformSize((Node)this.registerButton, (boolean)false);
        } else {
            this.getButtonTypes().addAll((Object[])new ButtonType[]{cancel, ask, bug});
        }
        this.bugButton = (Button)this.lookupButton(bug);
        this.questionButton = (Button)this.lookupButton(ask);
        this.cancelButton = (Button)this.lookupButton(cancel);
        this.questionButton.setOnAction(this::askQuestion);
        this.bugButton.visibleProperty().bind((ObservableValue)this.expandedProperty());
        ButtonBar.setButtonUniformSize((Node)this.cancelButton, (boolean)false);
        ButtonBar.setButtonUniformSize((Node)this.questionButton, (boolean)false);
        ButtonBar.setButtonUniformSize((Node)this.bugButton, (boolean)false);
        this.hideErrorMessage();
        this.emailAddress.setText("");
        this.phoneNumber.setText("");
        this.problemDescription.setText("");
        if (this.plugin != null) {
            this.questionButton.setVisible(this.plugin.getSupportUrl() != null);
        }
        this.setExpanded(false);
        this.includeLogFile.setSelected(true);
        if (this.plugin instanceof RegisterablePlugin) {
            this.productVersionLabel.setText(this.plugin.getVersion().stringVersion);
            this.licenseTypeLabel.setText(this.registration.getLicense().getVariantName());
            this.registeredToField.setText(this.registration.getCompanyName());
            this.registeredToLabel.setText(this.registration.getCompanyName());
            if (this.registration != null) {
                this.licenseKeyField.setText(this.displayLicenseKey ? this.registration.getLicenseKey() : "");
            } else {
                this.licenseKeyField.setText("");
            }
        } else {
            this.licenseKeyField.getParent().setVisible(false);
        }
    }

    protected Node createDetailsButton() {
        Hyperlink detailsButton = new Hyperlink();
        ResourceBundle bundle = ResourceBundle.getBundle(RegisterDialogPane.class.getCanonicalName());
        String moreText = bundle.getString("Dialog.detail.button.more");
        String lessText = bundle.getString("Dialog.detail.button.less");
        InvalidationListener expandedListener = o -> {
            boolean isExpanded = this.isExpanded();
            detailsButton.setText(isExpanded ? lessText : moreText);
            detailsButton.getStyleClass().setAll((Object[])new String[]{"details-button", isExpanded ? "less" : "more"});
        };
        expandedListener.invalidated(null);
        this.expandedProperty().addListener(expandedListener);
        detailsButton.setOnAction(ae -> this.setExpanded(!this.isExpanded()));
        return detailsButton;
    }

    public boolean isResizable() {
        return !this.isExpanded();
    }

    private void validateBugReportForm() throws IllegalArgumentException {
        if (this.emailAddress.getText() == null || this.emailAddress.getText().length() == 0) {
            throw new IllegalArgumentException("You must enter an email address");
        }
        if (!this.emailAddress.getText().contains("@") || !this.emailAddress.getText().contains(".")) {
            throw new IllegalArgumentException("Invalid email address");
        }
    }
}

