/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.data;

import com.prosc.format.FlexibleDateFormat;
import com.prosc.shared.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicTypeConverter {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final Logger log = Logger.getLogger(BasicTypeConverter.class.getName());

    public static Object convertObjectToClass(Object value, boolean nullable, Class<?> expectedType) {
        if (expectedType == String.class) {
            return BasicTypeConverter.convertObjectToString(value, nullable);
        }
        if (expectedType == Integer.class || expectedType == Integer.TYPE) {
            return BasicTypeConverter.convertObjectToInteger(value, nullable);
        }
        if (expectedType == Float.class || expectedType == Float.TYPE) {
            return BasicTypeConverter.convertObjectToFloat(value, nullable);
        }
        if (expectedType == Long.class || expectedType == Long.TYPE) {
            return BasicTypeConverter.convertObjectToLong(value, nullable);
        }
        if (expectedType == Double.class || expectedType == Double.TYPE) {
            return BasicTypeConverter.convertObjectToDouble(value, nullable);
        }
        if (expectedType == Number.class) {
            if (value.getClass() == byte[].class) {
                return BasicTypeConverter.convertByteArrayToNumber((byte[])value);
            }
            return BasicTypeConverter.convertObjectToNumber(value, nullable);
        }
        if (expectedType == BigDecimal.class) {
            return BasicTypeConverter.convertObjectToBigDecimal(value, nullable);
        }
        if (expectedType == Boolean.class || expectedType == Boolean.TYPE) {
            return BasicTypeConverter.convertObjectToBoolean(value, nullable);
        }
        if (expectedType == Byte.class || expectedType == Byte.TYPE) {
            return BasicTypeConverter.convertObjectToByte(value, nullable);
        }
        if (expectedType == Short.class) {
            return BasicTypeConverter.convertObjectToShort(value, nullable);
        }
        if (expectedType == Time.class) {
            return BasicTypeConverter.convertObjectToTime(value, nullable);
        }
        if (expectedType == Date.class) {
            return BasicTypeConverter.convertObjectToDate(value, nullable);
        }
        if (expectedType == Reader.class) {
            return BasicTypeConverter.convertObjectToCharacterStream(value, nullable);
        }
        if (expectedType == Timestamp.class) {
            return BasicTypeConverter.convertObjectToTimestamp(value, nullable);
        }
        if (expectedType == XMLGregorianCalendar.class) {
            return BasicTypeConverter.convertObjectToXMLGregorianCalendar(value, nullable);
        }
        if (expectedType == InputStream.class) {
            return BasicTypeConverter.convertObjectToBinaryStream(value, nullable);
        }
        throw new IllegalArgumentException("There is no converter that supports the target class " + expectedType.toString());
    }

    public static String convertObjectToString(Object input, boolean nullable) {
        if (input == null) {
            return nullable ? null : "";
        }
        if (input instanceof String) {
            return (String)input;
        }
        if (input instanceof Clob) {
            Clob clob = (Clob)input;
            try {
                int length = (int)clob.length();
                return clob.getSubString(1L, length);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Could not get contents of CLOB " + input);
                return String.valueOf(input);
            }
        }
        if (input instanceof Time) {
            return String.valueOf(input);
        }
        if (input instanceof Date) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            df.setTimeZone(UTC);
            return df.format(input);
        }
        if (input instanceof java.util.Date) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(input);
        }
        if (input instanceof Integer) {
            return new DecimalFormat("#").format(input);
        }
        if (input instanceof byte[]) {
            Number number = BasicTypeConverter.convertByteArrayToNumber((byte[])input);
            if (number.intValue() == 0) {
                return "false";
            }
            if (number.intValue() == 1) {
                return "true";
            }
            return String.valueOf(number);
        }
        return String.valueOf(input);
    }

    public static Integer convertObjectToInteger(Object input, boolean nullable) {
        if (input == null) {
            return nullable ? null : Integer.valueOf(0);
        }
        if (input instanceof Integer) {
            return (Integer)input;
        }
        if (input instanceof Number) {
            return ((Number)input).intValue();
        }
        if (input instanceof Boolean) {
            return (Boolean)input != false ? 1 : 0;
        }
        if (input instanceof String) {
            String trimmedInput = BasicTypeConverter.formatStringAsNumeric((String)input, nullable);
            if (StringUtils.isEmpty(trimmedInput)) {
                if (nullable) {
                    return null;
                }
                throw new IllegalArgumentException("Received an empty string as input to convert to a integer, but nullable is false");
            }
            try {
                return Integer.valueOf(trimmedInput);
            }
            catch (NumberFormatException e) {
                try {
                    return NumberFormat.getNumberInstance().parse(trimmedInput).intValue();
                }
                catch (ParseException e1) {
                    Boolean aBoolean = Boolean.valueOf(trimmedInput);
                    return aBoolean != false ? 1 : 0;
                }
            }
        }
        throw new IllegalArgumentException("Could not convert " + String.valueOf(input) + " to an integer.");
    }

    public static Float convertObjectToFloat(Object input, boolean nullable) {
        if (input == null) {
            return nullable ? null : Float.valueOf(0.0f);
        }
        if (input instanceof Float) {
            return (Float)input;
        }
        if (input instanceof Number) {
            return Float.valueOf(((Number)input).floatValue());
        }
        if (input instanceof Boolean) {
            return Float.valueOf((Boolean)input != false ? 1.0f : 0.0f);
        }
        if (input instanceof String) {
            String trimmedInput = BasicTypeConverter.formatStringAsNumeric((String)input, nullable);
            if (StringUtils.isEmpty(trimmedInput)) {
                if (nullable) {
                    return null;
                }
                throw new IllegalArgumentException("Received an empty string as input to convert to a float, but nullable is false");
            }
            try {
                return Float.valueOf(trimmedInput);
            }
            catch (NumberFormatException e) {
                try {
                    return Float.valueOf(NumberFormat.getNumberInstance().parse(trimmedInput).floatValue());
                }
                catch (ParseException e1) {
                    Boolean aBoolean = Boolean.valueOf(trimmedInput);
                    return Float.valueOf(aBoolean != false ? 1.0f : 0.0f);
                }
            }
        }
        throw new IllegalArgumentException("Could not convert " + String.valueOf(input) + " to a float.");
    }

    public static Long convertObjectToLong(Object input, boolean nullable) {
        if (input == null) {
            return nullable ? null : Long.valueOf(0L);
        }
        if (input instanceof Long) {
            return (Long)input;
        }
        if (input instanceof Number) {
            return ((Number)input).longValue();
        }
        if (input instanceof Boolean) {
            return (Boolean)input != false ? 1L : 0L;
        }
        if (input instanceof String) {
            String trimmedInput = BasicTypeConverter.formatStringAsNumeric((String)input, nullable);
            if (StringUtils.isEmpty(trimmedInput)) {
                if (nullable) {
                    return null;
                }
                throw new IllegalArgumentException("Received an empty string as input to convert to a long, but nullable is false");
            }
            try {
                return Long.valueOf(trimmedInput);
            }
            catch (NumberFormatException e) {
                try {
                    return NumberFormat.getNumberInstance().parse(trimmedInput).longValue();
                }
                catch (ParseException e1) {
                    Boolean aBoolean = Boolean.valueOf(trimmedInput);
                    return aBoolean != false ? 1L : 0L;
                }
            }
        }
        if (input instanceof java.util.Date) {
            return ((java.util.Date)input).getTime();
        }
        throw new IllegalArgumentException("Could not convert " + String.valueOf(input) + " to a long.");
    }

    public static Double convertObjectToDouble(Object input, boolean nullable) {
        if (input == null) {
            return nullable ? null : Double.valueOf(0.0);
        }
        if (input instanceof Double) {
            return (Double)input;
        }
        if (input instanceof Number) {
            return ((Number)input).doubleValue();
        }
        if (input instanceof Boolean) {
            return (Boolean)input != false ? 1.0 : 0.0;
        }
        if (input instanceof String) {
            String trimmedInput = BasicTypeConverter.formatStringAsNumeric((String)input, nullable);
            if (StringUtils.isEmpty(trimmedInput)) {
                if (nullable) {
                    return null;
                }
                throw new IllegalArgumentException("Received an empty string as input to convert to a double, but nullable is false");
            }
            try {
                return Double.valueOf(trimmedInput);
            }
            catch (NumberFormatException e) {
                try {
                    return NumberFormat.getNumberInstance().parse(trimmedInput).doubleValue();
                }
                catch (ParseException e1) {
                    return Boolean.valueOf(trimmedInput) != false ? 1.0 : 0.0;
                }
            }
        }
        if (input instanceof java.util.Date) {
            return ((java.util.Date)input).getTime();
        }
        throw new IllegalArgumentException("Could not convert " + String.valueOf(input) + " to a double.");
    }

    public static Number convertObjectToNumber(Object input, boolean nullable) {
        if (input == null) {
            return nullable ? null : Integer.valueOf(0);
        }
        if (input instanceof Number) {
            return (Number)input;
        }
        if (input instanceof String) {
            return BasicTypeConverter.convertObjectToBigDecimal(input, nullable);
        }
        if (input instanceof Boolean) {
            return (Boolean)input != false ? 1 : 0;
        }
        if (input instanceof byte[]) {
            return BasicTypeConverter.convertByteArrayToNumber((byte[])input);
        }
        throw new IllegalArgumentException("Could not convert " + String.valueOf(input) + " to a Number.");
    }

    @NotNull
    private static Number convertByteArrayToNumber(byte[] array) {
        if (array.length == 1) {
            Byte by = array[0];
            if (by == null) {
                BasicTypeConverter.$$$reportNull$$$0(0);
            }
            return by;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(array);
        if (array.length == 2) {
            Short s = byteBuffer.getShort();
            if (s == null) {
                BasicTypeConverter.$$$reportNull$$$0(1);
            }
            return s;
        }
        if (array.length <= 4) {
            Integer n = byteBuffer.getInt();
            if (n == null) {
                BasicTypeConverter.$$$reportNull$$$0(2);
            }
            return n;
        }
        if (array.length <= 8) {
            Long l = byteBuffer.getLong();
            if (l == null) {
                BasicTypeConverter.$$$reportNull$$$0(3);
            }
            return l;
        }
        BigInteger bigInteger = new BigInteger(array);
        if (bigInteger == null) {
            BasicTypeConverter.$$$reportNull$$$0(4);
        }
        return bigInteger;
    }

    public static BigDecimal convertObjectToBigDecimal(Object input, boolean nullable) {
        if (input == null) {
            return nullable ? null : BigDecimal.valueOf(0L);
        }
        if (input instanceof BigDecimal) {
            return (BigDecimal)input;
        }
        if (input instanceof Boolean) {
            return (Boolean)input != false ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        if (input instanceof String) {
            String trimmedInput = BasicTypeConverter.formatStringAsNumeric((String)input, nullable);
            if (trimmedInput == null && nullable) {
                return null;
            }
            try {
                return new BigDecimal(trimmedInput);
            }
            catch (NumberFormatException e) {
                try {
                    NumberFormat numberFormat = NumberFormat.getNumberInstance();
                    Number number = numberFormat.parse(trimmedInput);
                    return new BigDecimal(number.toString());
                }
                catch (ParseException e1) {
                    Boolean aBoolean = Boolean.valueOf(trimmedInput);
                    long numeric = aBoolean != false ? 1L : 0L;
                    return BigDecimal.valueOf(numeric);
                }
            }
        }
        if (input instanceof Double) {
            return BigDecimal.valueOf((Double)input);
        }
        if (input instanceof Long) {
            return BigDecimal.valueOf((Long)input);
        }
        if (input instanceof Number) {
            return BigDecimal.valueOf(((Number)input).doubleValue());
        }
        throw new IllegalArgumentException("Could not convert " + String.valueOf(input) + " to a BigDecimal.");
    }

    @Nullable
    private static String formatStringAsNumeric(String input, boolean nullable) {
        String trimmedInput = input.trim();
        if (trimmedInput.length() == 0) {
            if (nullable) {
                return null;
            }
            throw new IllegalArgumentException("Received an empty string as input to convert to a BigDecimal, but nullable is false");
        }
        if (trimmedInput.startsWith("+")) {
            trimmedInput = trimmedInput.substring(1).trim();
        }
        return trimmedInput;
    }

    public static Boolean convertObjectToBoolean(Object input, boolean nullable) {
        if (input == null) {
            return nullable ? null : Boolean.valueOf(false);
        }
        if (input instanceof Boolean) {
            return (Boolean)input;
        }
        if (input instanceof Number) {
            return ((Number)input).intValue() != 0;
        }
        if (input instanceof String) {
            String trimmedString = ((String)input).trim();
            if (trimmedString.length() == 0) {
                if (nullable) {
                    return null;
                }
                throw new IllegalArgumentException("Received an empty string as input to convert to a boolean, but nullable is false");
            }
            if ("yes".equalsIgnoreCase(trimmedString)) {
                trimmedString = "true";
            } else if ("no".equalsIgnoreCase(trimmedString)) {
                trimmedString = "false";
            }
            return Boolean.valueOf(trimmedString);
        }
        throw new IllegalArgumentException("Could not convert " + String.valueOf(input) + " to a boolean.");
    }

    public static Byte convertObjectToByte(Object input, boolean nullable) {
        if (input == null) {
            return nullable ? null : Byte.valueOf((byte)0);
        }
        if (input instanceof Byte) {
            return (Byte)input;
        }
        if (input instanceof Number) {
            return ((Number)input).byteValue();
        }
        if (input instanceof String) {
            String trimmedString = ((String)input).trim();
            if (trimmedString.length() == 0) {
                if (nullable) {
                    return null;
                }
                throw new IllegalArgumentException("Received an empty string as input to convert to a byte, but nullable is false");
            }
            return Byte.valueOf(trimmedString);
        }
        throw new IllegalArgumentException("Could not convert " + String.valueOf(input) + " to a byte.");
    }

    public static Short convertObjectToShort(Object input, boolean nullable) {
        if (input == null) {
            return nullable ? null : Short.valueOf((short)0);
        }
        if (input instanceof Short) {
            return (Short)input;
        }
        if (input instanceof Number) {
            return ((Number)input).shortValue();
        }
        if (input instanceof Boolean) {
            return (Boolean)input != false ? (short)1 : 0;
        }
        if (input instanceof String) {
            String trimmedInput = BasicTypeConverter.formatStringAsNumeric((String)input, nullable);
            if (StringUtils.isEmpty(trimmedInput)) {
                if (nullable) {
                    return null;
                }
                throw new IllegalArgumentException("Received an empty string as input to convert to a short, but nullable is false");
            }
            try {
                return Short.valueOf(trimmedInput);
            }
            catch (NumberFormatException e) {
                try {
                    return NumberFormat.getNumberInstance().parse(trimmedInput).shortValue();
                }
                catch (ParseException e1) {
                    return Boolean.valueOf(trimmedInput) != false ? (short)1 : 0;
                }
            }
        }
        throw new IllegalArgumentException("Could not convert " + String.valueOf(input) + " to a short.");
    }

    public static Time convertObjectToTime(Object input, Boolean nullable) {
        if (input == null) {
            return nullable != false ? null : new Time(0L);
        }
        if (input instanceof Time) {
            return (Time)input;
        }
        if (input instanceof Number) {
            return new Time(((Number)input).longValue());
        }
        if (input instanceof String) {
            String trimmedString = ((String)input).trim();
            if (trimmedString.length() == 0) {
                if (nullable.booleanValue()) {
                    return null;
                }
                throw new IllegalArgumentException("Received an empty string as input to convert to a Time, but nullable is false");
            }
            try {
                int count = StringUtils.patternCount(trimmedString, ":");
                java.util.Date date = count == 0 ? new SimpleDateFormat("HH").parse(trimmedString) : (count == 1 ? new SimpleDateFormat("HH:mm").parse(trimmedString) : new SimpleDateFormat("HH:mm:ss").parse(trimmedString));
                return new Time(date.getTime());
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Could not parse string value '" + input + "' as a time value");
            }
        }
        throw new IllegalArgumentException("Could not convert " + String.valueOf(input) + " to a time.");
    }

    public static Date convertObjectToDate(Object input, Boolean nullable) {
        if (input == null) {
            return nullable != false ? null : new Date(0L);
        }
        if (input instanceof Date) {
            return (Date)input;
        }
        if (input instanceof java.util.Date) {
            return new Date(((java.util.Date)input).getTime());
        }
        if (input instanceof XMLGregorianCalendar) {
            return new Date(((XMLGregorianCalendar)input).toGregorianCalendar().getTime().getTime() + (long)(TimeZone.getDefault().getRawOffset() * -1));
        }
        if (input instanceof Number) {
            return new Date(((Number)input).longValue());
        }
        if (input instanceof String) {
            String trimmedString = ((String)input).trim();
            if (trimmedString.length() == 0) {
                if (nullable.booleanValue()) {
                    return null;
                }
                throw new IllegalArgumentException("Received an empty string as input to convert to a Date, but nullable is false");
            }
            try {
                return new Date(new FlexibleDateFormat().parse(trimmedString).getTime());
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Could not parse string value '" + input + "' as a date value");
            }
        }
        throw new IllegalArgumentException("Could not convert value '" + String.valueOf(input) + "' as a date value");
    }

    public static Reader convertObjectToCharacterStream(Object input, Boolean nullable) {
        if (input == null) {
            return nullable != false ? null : new StringReader("");
        }
        if (input instanceof Reader) {
            return (Reader)input;
        }
        if (input instanceof Clob) {
            try {
                return ((Clob)input).getCharacterStream();
            }
            catch (SQLException e) {
                throw new IllegalArgumentException("Error occurred while attempting to convert " + String.valueOf(input) + " to a Reader.", e);
            }
        }
        String stringVersion = BasicTypeConverter.convertObjectToString(input, nullable);
        return new StringReader(stringVersion);
    }

    public static Timestamp convertObjectToTimestamp(Object input, Boolean nullable) {
        if (input == null) {
            return nullable != false ? null : new Timestamp(0L);
        }
        if (input instanceof Timestamp) {
            return (Timestamp)input;
        }
        if (input instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)input).getTime());
        }
        if (input instanceof Number) {
            return new Timestamp(((Number)input).longValue());
        }
        if (input instanceof XMLGregorianCalendar) {
            return new Timestamp(((XMLGregorianCalendar)input).toGregorianCalendar().getTimeInMillis());
        }
        if (input instanceof String) {
            String trimmedString = ((String)input).trim();
            if (trimmedString.length() == 0) {
                if (nullable.booleanValue()) {
                    return null;
                }
                throw new IllegalArgumentException("Received an empty string as input to convert to a Timestamp, but nullable is false");
            }
            try {
                return new Timestamp(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(trimmedString).getTime());
            }
            catch (ParseException e) {
                try {
                    return new Timestamp(new FlexibleDateFormat().parse(trimmedString).getTime());
                }
                catch (ParseException e1) {
                    throw new IllegalArgumentException("Could not parse string value '" + input + "' as a timestamp value");
                }
            }
        }
        throw new IllegalArgumentException("Could not convert value '" + String.valueOf(input) + "' as a timestamp value");
    }

    public static XMLGregorianCalendar convertObjectToXMLGregorianCalendar(Object input, Boolean nullable) {
        if (input == null && nullable.booleanValue()) {
            return null;
        }
        if (input instanceof XMLGregorianCalendar) {
            return (XMLGregorianCalendar)input;
        }
        Timestamp timestamp = BasicTypeConverter.convertObjectToTimestamp(input, nullable);
        GregorianCalendar result = new GregorianCalendar();
        result.setTimeInMillis(timestamp.getTime());
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(result);
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream convertObjectToBinaryStream(Object input, boolean nullable) {
        try {
            if (input == null) {
                return nullable ? null : new ByteArrayInputStream(new byte[0]);
            }
            if (input instanceof InputStream) {
                return (InputStream)input;
            }
            if (input instanceof byte[]) {
                return new ByteArrayInputStream((byte[])input);
            }
            if (input instanceof Blob) {
                return ((Blob)input).getBinaryStream();
            }
            throw new IllegalArgumentException("Could not convert " + String.valueOf(input) + " to an InputStream.");
        }
        catch (SQLException e) {
            throw new IllegalArgumentException("Error occurred while attempting to convert " + String.valueOf(input) + " to an InputStream.", e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/prosc/data/BasicTypeConverter", "convertByteArrayToNumber"));
    }
}

