/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.core;

import com.prosc.io.IOUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class AppSettings
extends Properties {
    private static final Logger log = Logger.getLogger(AppSettings.class.getName());
    private final String[] args;
    private final int argKeyLength;
    private static AppSettings sharedInstance;

    public static AppSettings init(Class mainClass, String propertiesPath, Properties defaults, @NotNull String[] applicationArgs) {
        if (applicationArgs == null) {
            AppSettings.$$$reportNull$$$0(0);
        }
        InputStream propertiesStream = null;
        if (mainClass != null && propertiesPath != null && (propertiesStream = mainClass.getResourceAsStream(propertiesPath)) == null) {
            throw new IllegalArgumentException("Could not load input stream for file " + propertiesPath);
        }
        try {
            AppSettings appSettings = AppSettings.init(propertiesStream, defaults, applicationArgs);
            return appSettings;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (propertiesStream != null) {
                IOUtils.closeQuietly(propertiesStream);
            }
        }
    }

    public static AppSettings init(InputStream propertiesStream, Properties defaults, String[] applicationArgs) throws IOException {
        if (sharedInstance != null) {
            throw new IllegalStateException("init() cannot be called more than once.");
        }
        sharedInstance = new AppSettings(propertiesStream, defaults, applicationArgs);
        return sharedInstance;
    }

    public static AppSettings init() {
        if (sharedInstance != null) {
            throw new IllegalStateException("init() cannot be called more than once.");
        }
        try {
            sharedInstance = new AppSettings(null, null, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sharedInstance;
    }

    public static AppSettings getSharedInstance() {
        if (sharedInstance == null) {
            log.log(Level.WARNING, "AppSettings.init() was not called. This can be ignored, but it is preferable to call it explicitly, to avoid threading issues.", new RuntimeException("Stack trace only"));
            AppSettings.init();
        }
        return sharedInstance;
    }

    private AppSettings(InputStream propertiesStream, Properties defaults, String[] applicationArgs) throws IOException {
        super(defaults);
        if (propertiesStream != null) {
            this.load(propertiesStream);
        }
        this.args = applicationArgs;
        this.argKeyLength = this.args == null ? 0 : this.args.length - 1;
    }

    public String[] getApplicationArgs() {
        return this.args;
    }

    public void applySettings(Object target) {
        try {
            Map setters = this.scanSetters(target.getClass());
            this.applyProperties(target, setters);
            this.applyArgs(target, setters);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Map scanSetters(Class targetClass) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(targetClass);
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        HashMap<String, Method> result = new HashMap<String, Method>(descriptors.length);
        for (PropertyDescriptor descriptor : descriptors) {
            Method writer = descriptor.getWriteMethod();
            if (writer == null) continue;
            result.put(descriptor.getName().toLowerCase(), writer);
        }
        return result;
    }

    private void applyProperties(Object target, Map setters) throws IllegalAccessException, InvocationTargetException {
        Enumeration<?> en = this.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String value = super.getProperty(key);
            Method writer = (Method)setters.get(key.toLowerCase());
            if (writer == null) continue;
            writer.invoke(target, value);
        }
    }

    private void applyArgs(Object target, Map setters) throws IllegalAccessException, InvocationTargetException {
        for (int n = 0; n < this.args.length; ++n) {
            String key;
            Method writer;
            if (this.args[n].charAt(0) != '-' || (writer = (Method)setters.get(key = this.args[n].substring(1).toLowerCase())) == null || !this.takesOneStringParam(writer)) continue;
            String value = this.args[++n];
            writer.invoke(target, value);
        }
    }

    private boolean takesOneStringParam(Method writer) {
        return writer.getParameterTypes().length == 1 && writer.getParameterTypes()[0] == String.class;
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return super.containsKey(key) || this.getProperty(key.toString()) != null;
    }

    @Override
    public String getProperty(String key) {
        String[] matchingArgs = this.launchParamsAfterKey("-" + key);
        String result = matchingArgs.length > 0 ? matchingArgs[0] : super.getProperty(key);
        return result;
    }

    public String[] launchParamsAfterKey(String key) {
        LinkedList<String> result = new LinkedList<String>();
        key = key.toLowerCase();
        for (int i = 0; i < this.argKeyLength; ++i) {
            String eachParam = this.args[i].toLowerCase();
            if (!eachParam.equals(key)) continue;
            result.add(this.args[++i]);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public Object setProperty(String key, String value) {
        if (value == null) {
            log.warning("You cannot store a null value in AppSettings (key is " + key + "); ignoring.");
            return null;
        }
        return super.setProperty(key, value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationArgs", "com/prosc/core/AppSettings", "init"));
    }
}

